package meshviz.graph.sample.group2Axis;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoGroup2Axis;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    PoDomain domain = new PoDomain();
    domain.min.setValue(0,0,0);
    domain.max.setValue(10, 10,0);

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;

    PoGroup2Axis g2Axis = new PoGroup2Axis(new SbVec2f(0,0), new SbVec2f(10,10),
					   PoGroup2Axis.AxisTypes.LINEAR,
					   PoGroup2Axis.AxisTypes.LOGARITHMIC, "X-Axis", "Y-Axis") ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(domain);
      root.addChild(textAttr);
      root.addChild(g2Axis);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Group 2 Axis");
  }
}
