package meshviz.graph.sample.group4Axis;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoGroup4Axis;
import com.openinventor.meshviz.graph.PoLinearAxis;
import com.openinventor.meshviz.graph.PoLogAxis;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    PoDomain domain = new PoDomain();
    domain.min.setValue(0,0,0);
    domain.max.setValue(10, 10, 0);

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;

    PoGroup4Axis g4Axis  = new PoGroup4Axis(new SbVec2f(0,0), new SbVec2f(10,10),
					    PoGroup4Axis.AxisTypes.LINEAR,
					    PoGroup4Axis.AxisTypes.LOGARITHMIC, "X-Axis", "Y-Axis") ;

    PoLinearAxis xAxis = (PoLinearAxis)
      g4Axis.getPart("xUpAxis", true);

    PoLogAxis yAxis = (PoLogAxis)g4Axis.getPart("yLeftAxis", true);
    PoLinearAxis x2Axis = (PoLinearAxis)g4Axis.getPart("xDownAxis", true);
    PoLogAxis y2Axis = (PoLogAxis)g4Axis.getPart("yRightAxis", true);

    xAxis.set("bodyApp.material", "diffuseColor 1 0 0") ;
    yAxis.set("bodyApp.material", "diffuseColor 1 0 0") ;
    x2Axis.set("bodyApp.material", "diffuseColor 1 0 0") ;
    y2Axis.set("bodyApp.material", "diffuseColor 1 0 0") ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(domain);
      root.addChild(textAttr);
      root.addChild(g4Axis);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Group 4 axis");
  }
}
