package meshviz.graph.sample.group6Axis3;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoCube;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoGroup6Axis3;
import com.openinventor.meshviz.graph.PoLinearAxis;
import com.openinventor.meshviz.graph.PoLogAxis;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    PoDomain domain = new PoDomain();
    domain.min.setValue(0,0,0);
    domain.max.setValue(1, 10, 100);

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;

    PoGroup6Axis3 g6Axis = new PoGroup6Axis3(new SbVec3f(0,0,0), new SbVec3f(1,10,100),
					    PoGroup6Axis3.AxisTypes.LINEAR,
					    PoGroup6Axis3.AxisTypes.LOGARITHMIC,
					    PoGroup6Axis3.AxisTypes.LINEAR,  "X", "Y", "Z") ;

    PoLinearAxis xAxis = (PoLinearAxis)g6Axis.getPart("xUpAxis", true);
    PoLinearAxis x2Axis = (PoLinearAxis)g6Axis.getPart("xDownAxis", true);

    PoLogAxis yAxis = (PoLogAxis)g6Axis.getPart("yLeftAxis", true);
    PoLogAxis y2Axis = (PoLogAxis)g6Axis.getPart("yRightAxis", true);

    PoLinearAxis zAxis = (PoLinearAxis)g6Axis.getPart("zDownAxis", true);
    PoLinearAxis z2Axis = (PoLinearAxis)g6Axis.getPart("zUpAxis", true);

    xAxis.set("bodyApp.material", "diffuseColor 1 0 0") ;
    yAxis.set("bodyApp.material", "diffuseColor 1 0 0") ;
    zAxis.set("bodyApp.material", "diffuseColor 1 0 0") ;
    x2Axis.set("bodyApp.material", "diffuseColor 1 0 0") ;
    y2Axis.set("bodyApp.material", "diffuseColor 1 0 0") ;
    z2Axis.set("bodyApp.material", "diffuseColor 1 0 0") ;

    SoCube cube = new SoCube() ;
    cube.width.setValue(0.2F) ;
    cube.height.setValue(3) ;
    cube.depth.setValue(30) ;

    SoTranslation translate = new SoTranslation() ;
    translate.translation.setValue(0.5F, 5, 50) ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(domain);
      root.addChild(textAttr);
      root.addChild(g6Axis);
      root.addChild( domain.getTransform());
      root.addChild(translate);
      root.addChild(cube);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Group 6 Axis 3");
  }
}
