package meshviz.graph.sample.highLowClose;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoHighLowClose;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    float[] valX = {0, 1, 2, 3, 4} ;
    float[] valHigh = {1, 4, 5, 7, 4} ;
    float[] valLow = {-1, 2, 3, 0, 3} ;
    float[] valClose = {0, 3, 4, 2,  3} ;

    PoHighLowClose hlc = new PoHighLowClose(5, valX, valHigh, valLow, valClose) ;

    SoSeparator root = new SoSeparator() ;
    root.addChild(hlc) ;

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("High Low Close");
  }
}
