package meshviz.graph.sample.label;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoGroup2Axis;
import com.openinventor.meshviz.graph.PoLabel;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoIrregularMesh1D;
import com.openinventor.meshviz.nodes.PoMesh1DHints;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;


/*----------------------------------------------------------------------------*/

public class Main extends Example
{
  private IViewerExaminer myViewer;

  @Override
  public void start() {
    float x[] = {0.5F, 1.5F, 1.8F, 2.4F, 3.2F, 4.5F, 6.3F,
                 6.9F, 8.0F, 8.5F, 9.0F, 9.5F, 9.8F, 10.F
    } ;
    float y[] = {0.5F, 3.8F, 1.2F, 1.9F, 6.3F, 7.2F, 9.3F,
                 7.2F, 6.0F, 6.3F, 7.5F, 4.1F, 3.5F, 1.5F
    }  ;

    myViewer = ViewerComponentsFactory.createViewerExaminer();

    PoDomain myDomain = new PoDomain();
    myDomain.min.setValue(0, 0, 0) ;
    myDomain.max.setValue(10, 10, 0) ;

    PoMiscTextAttr myTextAttr = new PoMiscTextAttr();
    myTextAttr.fontName.setValue("Courier New" );

    SoAnnotation root = new SoAnnotation();

    PoIrregularMesh1D mesh1D = new PoIrregularMesh1D();
    mesh1D.setGeometry(x.length, x) ;
    mesh1D.addValuesSet(0, y) ;

    PoMesh1DHints mesh1DHints = new PoMesh1DHints();
    mesh1DHints.geomInterpretation.setValue(PoMesh1DHints.GeomInterpretations.SMOOTH);

    PoLabel label = new PoLabel();

    PoGroup2Axis g2Axis = new
        PoGroup2Axis(new SbVec2f(0,0), new SbVec2f(10, 10),
                     PoGroup2Axis.AxisTypes.LINEAR,
                     PoGroup2Axis.AxisTypes.LINEAR,
                     "X-Axis", "Y-Axis") ;

    { // assemble scene graph
      root.addChild(myDomain);
      root.addChild(mesh1DHints);
      root.addChild(mesh1D);
      root.addChild(myTextAttr);
      root.addChild(label);
      root.addChild(g2Axis);
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Label");
  }
}
