package meshviz.graph.sample.labelField;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoLabelField;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private static final float[] values =
  {1.2665F, 3.45F, 7.5F, 89.99F, 12, 11.55F, 789.3F, 3.31416F, 5.5F, 2} ;
  private static final String[] strings =
  {"Point 1", "Point 2", "Point 3", "Point 4", "Point 5",
   "Point 6", "Point 7", "Point 8", "Point 9", "Point 10"} ;
  private static final SbVec2f[] points =
  {new SbVec2f(1,1), new SbVec2f(2,2), new SbVec2f(3,3),
   new SbVec2f(4,4), new SbVec2f(5,5), new SbVec2f(6,6),
   new SbVec2f(7,7), new SbVec2f(8,8), new SbVec2f(9,9), new SbVec2f(9.5F,10)} ;
  private IViewerExaminer myViewer;


  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    PoLabelField labelFld = new PoLabelField(points, strings, values, 0.5F) ;
    labelFld.set("appearance.font", "name Arial size 10.") ;

    SoSeparator root = new SoSeparator() ;
    root.addChild(labelFld) ;

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Label Field");
  }
}
