package meshviz.graph.sample.pieChartRep;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.nodes.SoAnnoText3Property;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoRotationXYZ;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoChart;
import com.openinventor.meshviz.graph.PoPieChartRep;
import com.openinventor.meshviz.nodes.PoBevelEdge;
import com.openinventor.meshviz.nodes.PoIrregularMesh1D;
import com.openinventor.meshviz.nodes.PoLabelHints;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

/*----------------------------------------------------------------------------*/

public class Main extends Example
{
  private IViewerExaminer myViewer;

  @Override
  public void start() {
    String sliceNames[]={
      "Post-Processing", "Oil&Gaz", "Aerospace",
      "Chemistry", "CAO", "Meterology"
    } ;
    float    sliceValues[] = {350, 150, 160, 200, 100, 40} ;
    SbColor  sliceDiffColors[] = {
      new SbColor(0.2f, 0.2f, 0.6f), new SbColor(0.2f, 0.6f, 0.6f),
      new SbColor(0.6f, 0.6f, 0.3f), new SbColor(0.6f, 0.0f, 0.f),
      new SbColor(0.6f, 0.3f, 0.3f), new SbColor(0.6f, 0.2f, 0.2f)
        } ;

    SbColor  sliceSpecColors[] = {
      new SbColor(0.2f, 0.2f, 0.8f), new SbColor(0.5f, 0.8f, 0.8f),
      new SbColor(0.8f, 0.8f, 0.4f), new SbColor(0.8f, 0.0f, 0.f),
      new SbColor(0.8f, 0.4f, 0.4f), new SbColor(0.8f, 0.4f, 0.4f)
        } ;
    float    sliceToTranslateRadius[] = {0.2f, 0.2f, 0.2f} ;
    short    sliceToTranslateNumber[] = {0, 1, 2, } ;

    myViewer = ViewerComponentsFactory.createViewerExaminer();

    PoMiscTextAttr myTextAttr = new PoMiscTextAttr();
    myTextAttr.fontName.setValue("Courier New" );

    SoSeparator root = new SoSeparator();

    PoIrregularMesh1D mesh1D = new PoIrregularMesh1D();
    mesh1D.setGeometry(sliceValues.length, sliceValues) ;
    mesh1D.addStringsSet(0, sliceNames) ;

    SoAnnoText3Property annoProp = new SoAnnoText3Property();
    annoProp.renderPrintType.setValue(SoAnnoText3Property.RenderPrintTypes.RENDER2D_PRINT_RASTER);
    annoProp.fontSizeHint.setValue(SoAnnoText3Property.FontSizeHints.ANNOTATION);

    PoLabelHints labelHints = new PoLabelHints();
    labelHints.isLabelLineVisible.setValue(true);

    SoMaterial mat = new SoMaterial();
    mat.diffuseColor.setValues(0, sliceDiffColors) ;
    mat.specularColor.setValues(0, sliceSpecColors) ;
    mat.emissiveColor.setValue(0, 0, 0) ;
    mat.shininess.setValue(0.8f) ;
    mat.transparency.setValue(0) ;

    PoBevelEdge bevelEdge = new PoBevelEdge();
    bevelEdge.radius.setValue(0.2f );

    PoPieChartRep pieChart = new PoPieChartRep();
    pieChart.set("annotationLineApp.drawStyle", "linePattern 0xF0F0") ;
    pieChart.colorBinding.setValue(PoChart.ColorBindings.PER_PART );
    pieChart.sliceToTranslateNumber.setValues(0, sliceToTranslateNumber) ;
    pieChart.sliceToTranslateRadius.setValues(0, sliceToTranslateRadius) ;
    pieChart.material.setValue(mat) ;
    pieChart.isAnnoSliceColor.setValue(true );
    pieChart.isNameVisible.setValue(true );
    pieChart.annoDistToCenter.setValue(0.9F);
    pieChart.radiusMin.setValue(0.4f );

    SoRotationXYZ rotXYZ = new SoRotationXYZ();
    rotXYZ.axis.setValue(SoRotationXYZ.AxisType.X);
    rotXYZ.angle.setValue(-1 );

    { // assemble scene graph
      root.addChild(rotXYZ);
      root.addChild(annoProp);
      root.addChild(labelHints);
      root.addChild(myTextAttr);
      root.addChild(bevelEdge);
      root.addChild(mesh1D);
      root.addChild(pieChart);
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("PieChartRep");
  }
}
