package meshviz.graph.sample.pointsFieldBars;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.graph.PoGroup6Axis3;
import com.openinventor.meshviz.graph.PoPointsFieldBars;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoLinearDataMapping;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SbVec3f[] point = { new SbVec3f(10,10,12), new SbVec3f(20,60,60), new SbVec3f(60,20,90),
			new SbVec3f(50,40,50), new SbVec3f(80,70,30), new SbVec3f(80,30,20),
			new SbVec3f(30,50,40), new SbVec3f(30,20,60), new SbVec3f(30,80,30)};

    float[] barValues = {12, 60, 90, 50, 20, 40, 60, 30} ;

    PoLinearDataMapping dataMapping = new PoLinearDataMapping() ;
    dataMapping.color1.setValue(new SbColor(1,1,1));
    dataMapping.color2.setValue(new SbColor(1,0,0));
    dataMapping.value1.setValue(0);
    dataMapping.value2.setValue(100);

    PoDomain domain = new PoDomain();
    domain.min.setValue(0,0,0);
    domain.max.setValue(90, 90, 90);

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;

    PoGroup6Axis3 g6Axis  = new PoGroup6Axis3(new SbVec3f(0,0,0), new SbVec3f(90,90,90),
					      PoGroup6Axis3.AxisTypes.LINEAR, PoGroup6Axis3.AxisTypes.LINEAR,
					      PoGroup6Axis3.AxisTypes.LINEAR, "X", "Y", "Z") ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(dataMapping);
      root.addChild(domain);
      root.addChild(textAttr);
      root.addChild(g6Axis);
    }

    PoPointsFieldBars bars = new PoPointsFieldBars(point, barValues, 6, 6) ;
    root.addChild(bars) ;

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Points Field Bars");
  }
}
