package meshviz.graph.sample.timeAxis;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;
import com.openinventor.meshviz.graph.PoAxis;
import com.openinventor.meshviz.graph.PoTimeAxis;
import com.openinventor.meshviz.nodes.PoDateFormatMapping;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoMiscTextAttr;

import util.Example;
import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private IViewerExaminer myViewer;

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();
    myViewer.getRenderArea().setNavigationMode(NavigationMode.PLANE);

    String date1 = new String("09/10/94 16:44:30");
    String date2 = new String("09/12/94 16:44:31");
    String format = "dmyh'\"" ;
    String[] gradRep = {
      " 1SEC  s'\"'   : 1MIN  H'h'm' ' D'/'3M'/'4Y",
      "30SEC  s'\" 'm'''' : 1HOU 'h ' D'/'3M'/'4Y",
      " 1MIN  m''''   : 1HOU  H'h ' D'/'3M'/'4Y",
      "30MIN  H'h'm''''   : 1DAY  D'/'3M'/'4Y",
      " 1HOU  H'h'    : 1DAY  D'/'3M'/'4Y",
      "12HOU  D H'h'  : 1MON  3M'/'4Y",
      "DAY  D       : 1MON  3M'/'4Y",
      "15DAY  D'/'3M  : 6MON  4Y",
      " 1MON  3M      : 1YEA  4Y",
      " 1YEA  4Y"
    };
    String timesPeriod = "30SEC 15MIN 1HOU 12HOU 1DAY 15DAY 1MON 6MON 1YEA" ;

    PoDomain domain = new PoDomain();
    domain.min.setValue(0,0,0);
    domain.max.setValue(1,1,0);

    PoMiscTextAttr textAttr = new PoMiscTextAttr() ;
    textAttr.fontName.setValue("Courier New") ;
    textAttr.lineLength.setValue((short)1);
    textAttr.endLineChar.setValue((short)':');

    PoDateFormatMapping dateFormMap = new PoDateFormatMapping() ;
    dateFormMap.date1.setValue(date1);
    dateFormMap.date2.setValue(date2);
    dateFormMap.coord1.setValue(0);
    dateFormMap.coord2.setValue(1);
    dateFormMap.format.setValue(format);

    PoTimeAxis timeAxis = new PoTimeAxis(date1, date2, 0) ;
    timeAxis.titleVisibility.setValue(PoAxis.Visibilities.VISIBILITY_ON) ;
    timeAxis.gradRep.setValues(0, gradRep) ;
    timeAxis.timesPeriod.setValue(timesPeriod) ;
    timeAxis.titleString.setValue("Time Axis") ;
    timeAxis.set("bodyApp.material", "diffuseColor 1 0 0") ;

    SoSeparator root = new SoSeparator() ;
    { // assemble scene graph
      root.addChild(domain);
      root.addChild(textAttr);
      root.addChild(dateFormMap);
      root.addChild(timeAxis);
    }

    myViewer.setSceneGraph(root) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Time Axis");
  }
}
