package meshviz.mesh.advanced.CartesianGrid2D;

import java.awt.BorderLayout;
import java.io.InputStream;
import java.net.URL;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.nodes.PoCartesianGrid2D;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.util.AsciiStreamReader;

import meshviz.mesh.advanced.meshViewer.MeshViewer;
import util.Example;

public class Main extends Example
{
  private static final int NUM_DATASET = 4;
  private PoCartesianGrid2D m_mesh;
  private SbVec3f m_min;
  private SbVec3f m_max;
  private float[][] vm;
  private int num_x;
  private int num_y;
  private MeshViewer m_meshViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("CartesianGrid2D");
  }

  @Override
  public void start() {
    String oivjhome = SoPreferences.getValue("OIVJHOME");
    m_mesh = new PoCartesianGrid2D();
    read_mesh(oivjhome + "/data/meshviz/CARTGRID.TOPO");
    vm = new float[NUM_DATASET][num_x*num_y];
    read_val(oivjhome + "/data/meshviz/GRID0.DAT", 0);
    read_val(oivjhome + "/data/meshviz/GRID1.DAT", 1);
    read_val(oivjhome + "/data/meshviz/GRID2.DAT", 2);
    read_val(oivjhome + "/data/meshviz/GRID3.DAT", 3);

    for (int i = 0; i < NUM_DATASET; i++)
        m_mesh.addValuesSet(i, vm[i]);

    PoDomain domain = new PoDomain();
    domain.min.setValue(m_min);
    domain.max.setValue(m_max);

    m_meshViewer = new MeshViewer();
    m_meshViewer.setDatasetIndex(3);

    final IViewerExaminer viewer = m_meshViewer.show(m_mesh, domain);

    setLayout(new BorderLayout());
    add(viewer.getComponent());
  }

  @Override
  public void stop()
  {
    m_meshViewer.stop();
  }

  private void read_mesh(String filename) {
    float x_min, y_min, x_max, y_max;

    URL url = MeshViewer.getURL(filename);
    if (url == null) {
      System.out.println("file " + filename + " not found");
      System.exit(1);
    }

    AsciiStreamReader meshFile;
    try {
      // Open stream
      System.out.println("Reading file  " + url.getFile());
      InputStream input = url.openStream();
      meshFile = new AsciiStreamReader(input);

      num_x = meshFile.readNextInt();
      num_y = meshFile.readNextInt();

      float[] x = new float[num_x * num_y];
      float[] y = new float[num_x * num_y];

      float xx = meshFile.readNextFloat();
      float yy = meshFile.readNextFloat();
      x[0] = x_min = x_max = xx;
      y[0] = y_min = y_max = yy;
      for (int i = 1; i < num_x * num_y; i++) {
        xx = meshFile.readNextFloat();
        yy = meshFile.readNextFloat();
        if (x_min > xx)
          x_min = xx;
        if (y_min > yy)
          y_min = yy;
        if (x_max < xx)
          x_max = xx;
        if (y_max < yy)
          y_max = yy;
        x[i] = xx;
        y[i] = yy;
      }

      input.close();

      m_min = new SbVec3f(x_min, y_min, 0);
      m_max = new SbVec3f(x_max, y_max, 64);

      m_mesh.setGeometry(num_x, num_y, x, y);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void read_val(String filename, int which_dataset) {
    URL url = MeshViewer.getURL(filename);
    if (url == null) {
      System.out.println("file " + filename + " not found");
      System.exit(1);
    }

    AsciiStreamReader dataFile;
    try {
      // Open stream
      System.out.println("Reading file  " + url.getFile());
      InputStream input = url.openStream();
      dataFile = new AsciiStreamReader(input);

      int num_val = num_x*num_y;
      for (int i = 0; i < num_val; i++)
        vm[which_dataset][i] = dataFile.readNextFloat();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
}
