package meshviz.mesh.advanced.HexahedronMesh3D;

import java.awt.BorderLayout;
import java.io.File;
import java.net.URL;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.nodes.PoHexahedronMesh3D;
import com.openinventor.meshviz.nodes.PoMeshProperty;
import com.openinventor.util.AsciiStreamReader;

import meshviz.mesh.advanced.meshViewer.MeshViewer;
import util.Example;

public class Main extends Example
{
  private MeshViewer m_meshViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Hexahedron Mesh 3D");
  }

  @Override
  public void start() {
    String oivjhome = SoPreferences.getValue("OIVJHOME");
    File f = new File(oivjhome + "/data/meshviz/poi3u32.txt");
    if (!f.exists()) {
      System.err.println("Data file not found or not installed.");
      System.err.println("You may need to download the optional MeshViz data files.");
      System.exit(1);
    }

    PoMeshProperty mesh;
    URL url = MeshViewer.getURL(oivjhome + "/data/meshviz/TURBO.DAT");
    if (url == null)
      return;

    mesh = initMesh(url);
    if (mesh == null)
      return;

    m_meshViewer = new MeshViewer();
    m_meshViewer.setCourtesyTitle("by courtesy of Turbomeca");

    final IViewerExaminer viewer = m_meshViewer.show(mesh);

    setLayout(new BorderLayout());
    add(viewer.getComponent());
  }

  @Override
  public void stop()
  {
    m_meshViewer.stop();
  }

  private PoHexahedronMesh3D initMesh(URL url) {
    PoHexahedronMesh3D mesh = null;
    AsciiStreamReader meshFile;

    try {
      final int numDataSet = 5;
      int numNodes;
      int numHexadrons;
      int[] hexahedronNodes;
      float[] xm, ym, zm;
      float[][] vm;
      SbVec3f[] vec;

      // Open stream
      System.out.println("Reading file  " + url.getFile());
      meshFile = new AsciiStreamReader(url.openStream());

      // Read number of nodes and hexahedrons
      numHexadrons = meshFile.readNextInt();
      numNodes = meshFile.readNextInt();
      System.out.println("Reading " + numHexadrons + " hexahedrons and " +
                         numNodes + " nodes coordinates");

      // Read hexahedrons
      hexahedronNodes = new int[8 * numHexadrons];
      for (int i = 0; i < 8 * numHexadrons; i++)
        hexahedronNodes[i] = meshFile.readNextInt();

      // Read nodes
      xm = new float[numNodes];
      ym = new float[numNodes];
      zm = new float[numNodes];
      for (int i = 0; i < numNodes; i++) {
        xm[i] = meshFile.readNextFloat();
        ym[i] = meshFile.readNextFloat();
        zm[i] = meshFile.readNextFloat();
      }

      System.out.println("Reading " + numDataSet + " data set values");
      vm = new float[numDataSet][numNodes];
      for (int i = 0; i < numNodes; i++)
        for (int iDataSet = 0; iDataSet < numDataSet; iDataSet++)
          vm[iDataSet][i] = meshFile.readNextFloat();

      // End of reading
      System.out.println("End reading file. Creating Scene graph.");

      // creating the mesh
      mesh = new PoHexahedronMesh3D();
      mesh.setGeometry(numNodes, xm, ym, zm, numHexadrons, hexahedronNodes);

      // dataSetName must have as many element as numDataSet value
      final String[] dataSetName = {
          "density",
          "momentum U",
          "momentum V",
          "momentum W",
          "enthalpy"
      };
      for (int i = 0; i < numDataSet; i++)
        mesh.addValuesSet(i, vm[i], dataSetName[i]);

      vec = new SbVec3f[numNodes];
      for (int i = 0; i < numNodes; i++)
        vec[i] = new SbVec3f(vm[1][i], vm[2][i], vm[3][i]);
      mesh.addVecsSet(0, vec);
    }
    catch (Exception e) {
      e.printStackTrace();
    }

    return mesh;
  }
}
