package meshviz.mesh.advanced.Meteo2D;

import java.awt.BorderLayout;
import java.net.URL;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoRegularCartesianGrid2D;
import com.openinventor.util.AsciiStreamReader;

import meshviz.mesh.advanced.meshViewer.MeshViewer;
import util.Example;

public class Main extends Example
{
  private PoRegularCartesianGrid2D m_mesh;
  private int m_numDataset;
  private float[][] v;
  private SbVec3f vec[];
  private MeshViewer m_meshViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Meteo 2D");
  }

  @Override
  public void start() {
    m_mesh = new PoRegularCartesianGrid2D();

    read_mesh(SoPreferences.getValue("OIVJHOME") + "/data/meshviz/METEO2D.DAT");

    String[] data_names = {"the", "ect", "vect->u", "vect->v", "vect->w"};

    for (int i = 0; i < m_numDataset; i++)
      m_mesh.addValuesSet(i, v[i], data_names[i]);
    m_mesh.addVecsSet(0, vec);

    PoDomain domain = new PoDomain();
    domain.min.setValue(new SbVec3f(0, 0, 0));
    domain.max.setValue(new SbVec3f(50.f, 50.f, 1.f));

    m_meshViewer = new MeshViewer();
    m_meshViewer.setCourtesyTitle("by courtesy of Meteo-France");
    m_meshViewer.setDatasetIndex(3);
    final IViewerExaminer viewer = m_meshViewer.show(m_mesh, domain);

    setLayout(new BorderLayout());
    add(viewer.getComponent());
  }

  @Override
  public void stop()
  {
    m_meshViewer.stop();
  }

  private void read_mesh(String filename) {
    URL url = MeshViewer.getURL(filename);
    if (url == null) {
      System.out.println("file " + filename + " not found");
      System.exit(1);
    }

    AsciiStreamReader meshFile;
    try {
      // Open stream
      System.out.println("Reading file  " + url.getFile());
      meshFile = new AsciiStreamReader(url.openStream());

      int num_x = meshFile.readNextInt();
      int num_y = meshFile.readNextInt();
      meshFile.readNextFloat();
      meshFile.readNextFloat();
      meshFile.readNextFloat();
      meshFile.readNextFloat();

      m_mesh.setGeometry(num_x, num_y, 0, 0, 50, 50);

      m_numDataset = meshFile.readNextInt();
      int num_nodes = num_x * num_y;
      v = new float[m_numDataset][num_nodes];
      for (int n = 0; n < m_numDataset; n++) {
        for (int i = 0; i < num_nodes; i++)
          v[n][i] = meshFile.readNextFloat();
      }

      meshFile.readNextInt();
      vec = new SbVec3f[num_nodes];
      for (int i = 0; i < num_nodes; i++) {
        float vx  = meshFile.readNextFloat();
        float vy  = meshFile.readNextFloat();
        float vz  = meshFile.readNextFloat();
        vec[i] = new SbVec3f(vx, vy, vz);
      }
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
}
