package meshviz.mesh.advanced.Meteorology;

import java.awt.BorderLayout;
import java.io.File;
import java.io.InputStream;
import java.net.URL;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.nodes.PoCartesianGrid3D;
import com.openinventor.util.AsciiStreamReader;

import meshviz.mesh.advanced.meshViewer.MeshViewer;
import util.Example;

public class Main extends Example
{
  private static final int NUM_DATASET = 5;
  private static final int NUM_X = 32;
  private static final int NUM_Y = 32;
  private static final int NUM_Z = 30;

  private PoCartesianGrid3D m_mesh;
  private float[][] v;
  private SbVec3f[] vec;
  private MeshViewer m_meshViewer;

  public Main() {
    v = new float[NUM_DATASET][NUM_X * NUM_Y * NUM_Z];
    vec = new SbVec3f[NUM_X * NUM_Y * NUM_Z];
  }

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Meteorology");
  }

  @Override
  public void start() {
    String oivjhome = SoPreferences.getValue("OIVJHOME");
    File f = new File(oivjhome + "/data/meshviz/poi3the32.txt");
    if (!f.exists()) {
      System.err.println("Data file not found or not installed.");
      System.err.println("You may need to download the optional MeshViz data files.");
      System.exit(1);
    }

    String[] data_names = {"the", "ect", "vect->u", "vect->v", "vect->w"};
    m_mesh = new PoCartesianGrid3D();

    read_topologie(oivjhome + "/data/meshviz/poi3z32.txt");
    read_value(oivjhome + "/data/meshviz/poi3the32.txt", 0);
    read_value(oivjhome + "/data/meshviz/poi3ect32.txt", 1);
    read_value(oivjhome + "/data/meshviz/poi3u32.txt", 2);
    read_value(oivjhome + "/data/meshviz/poi3v32.txt", 3);
    read_value(oivjhome + "/data/meshviz/poi3w32.txt", 4);

    for (int i = 0; i < NUM_DATASET; i++)
      m_mesh.addValuesSet(i, v[i], data_names[i]);

    for (int i = 0; i < NUM_X; i++)
      for (int j = 0; j < NUM_Y; j++)
        for (int k = 0; k < NUM_Z; k++) {
          vec[i*NUM_Y*NUM_Z + j*NUM_Z + k] = new SbVec3f
              (v[2][i*NUM_Y*NUM_Z + j*NUM_Z + k],
               v[3][i*NUM_Y*NUM_Z + j*NUM_Z + k],
               v[4][i*NUM_Y*NUM_Z + j*NUM_Z + k]);
        }
    m_mesh.addVecsSet(0, vec);
    // End of reading
    System.out.println("End reading file. Creating Scene graph.");

    m_meshViewer = new MeshViewer();
    m_meshViewer.setCourtesyTitle("by courtesy of Meteo-France");
    final IViewerExaminer viewer = m_meshViewer.show(m_mesh);

    setLayout(new BorderLayout());
    add(viewer.getComponent());
  }

  @Override
  public void stop()
  {
    m_meshViewer.stop();
  }

  private void read_topologie(String filename) {
    float[] x = new float[NUM_X * NUM_Y * NUM_Z];
    float[] y = new float[NUM_X * NUM_Y * NUM_Z];
    float[] z = new float[NUM_X * NUM_Y * NUM_Z];


    float dc = 625;
    float xc = 0.f;
    for (int i = 0; i < NUM_X; i++) {
      for (int j = 0; j < NUM_Y; j++) {
        for (int k = 0; k < NUM_Z; k++) {
          x[i*NUM_Y*NUM_Z + j*NUM_Z + k] = xc;
        }
      }
      xc += dc;
    }


    float yc = 0;
    for (int j = 0; j < NUM_Y; j++) {
      for (int i = 0; i < NUM_X; i++) {
        for (int k = 0; k < NUM_Z; k++) {
          y[i*NUM_Y*NUM_Z + j*NUM_Z + k] = yc;
        }
      }
      yc += dc;
    }


    System.out.println("start reading geometry file " + filename + " : " +
                       NUM_X + " " + NUM_Y + " " + NUM_Z);
    URL url = MeshViewer.getURL(filename);
    if (url == null) {
      System.out.println("file " + filename + " not found");
      System.exit(1);
    }

    try {
      InputStream input = url.openStream();
      AsciiStreamReader stream = new AsciiStreamReader(input);

      for (int k = 0; k < NUM_Z; k++) {
        for (int j = 0; j < NUM_Y; j++) {
          for (int i = 0; i < NUM_X; i++) {
            z[i*NUM_Y*NUM_Z + j*NUM_Z + k] = stream.readNextFloat();
          }
        }
      }

      input.close();
      m_mesh.setGeometry(NUM_X, NUM_Y, NUM_Z, x, y, z);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void read_value(String filename, int set_index) {
    URL url = MeshViewer.getURL(filename);
    if (url == null) {
      System.out.println("file " + filename + " not found");
      System.exit(1);
    }

    try {
      System.out.println("Start reading file " + filename + "...");
      InputStream input = url.openStream();
      AsciiStreamReader stream = new AsciiStreamReader(input);

      for (int k = 0; k < NUM_Z; k++) {
        for (int j = 0; j < NUM_Y; j++) {
          for (int i = 0; i < NUM_X; i++) {
            v[set_index][i*NUM_Y*NUM_Z + j*NUM_Z + k] = stream.readNextFloat();
          }
        }
      }

      input.close();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
}
