package meshviz.mesh.advanced.ParalGrid2D;

import java.awt.BorderLayout;
import java.io.InputStream;
import java.net.URL;

import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoParalCartesianGrid2D;
import com.openinventor.util.AsciiStreamReader;

import meshviz.mesh.advanced.meshViewer.MeshViewer;
import util.Example;

public class Main extends Example
{
  private static final int NUM_DATASET = 4;
  private PoParalCartesianGrid2D m_mesh;
  private PoDomain m_domain;
  private float[][] vm;
  private int num_x;
  private int num_y;
  private MeshViewer m_meshViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("ParalCartesianGrid2D");
  }

  @Override
  public void start() {
    m_mesh = new PoParalCartesianGrid2D();
    m_domain = new PoDomain();

    String oivjhome = SoPreferences.getValue("OIVJHOME");
    read_mesh(oivjhome + "/data/meshviz/PARALGRID.TOPO");
    vm = new float[NUM_DATASET][num_x*num_y];
    read_val(oivjhome + "/data/meshviz/GRID0.DAT", 0);
    read_val(oivjhome + "/data/meshviz/GRID1.DAT", 1);
    read_val(oivjhome + "/data/meshviz/GRID2.DAT", 2);
    read_val(oivjhome + "/data/meshviz/GRID3.DAT", 3);

    for (int i = 0; i < NUM_DATASET; i++)
      m_mesh.addValuesSet(i, vm[i]);

    m_meshViewer = new MeshViewer();
    m_meshViewer.setDatasetIndex(3);
    final IViewerExaminer viewer = m_meshViewer.show(m_mesh);

    setLayout(new BorderLayout());
    add(viewer.getComponent());
  }

  @Override
  public void stop()
  {
    m_meshViewer.stop();
  }

  private void read_mesh(String filename) {
    URL url = MeshViewer.getURL(filename);
    if (url == null) {
      System.out.println("file " + filename + " not found");
      System.exit(1);
    }

    AsciiStreamReader meshFile;
    try {
      // Open stream
      System.out.println("Reading file  " + url.getFile());
      InputStream input = url.openStream();
      meshFile = new AsciiStreamReader(input);

      num_x = meshFile.readNextInt();
      num_y = meshFile.readNextInt();

      float[] x = new float[num_x];
      float[] y = new float[num_y];

      for (int i = 0; i < num_x; i++)
        x[i] = meshFile.readNextFloat();
      for (int i = 0; i < num_y; i++)
        y[i] = meshFile.readNextFloat();

      m_mesh.setGeometry(num_x, num_y, x, y);

      m_domain.min.setValue(x[0], y[0], 0);
      m_domain.max.setValue(x[num_x - 1], y[num_y - 1], 1);

      input.close();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void read_val(String filename, int which_dataset) {
    URL url = MeshViewer.getURL(filename);
    if (url == null) {
      System.out.println("file " + filename + " not found");
      System.exit(1);
    }

    AsciiStreamReader dataFile;
    try {
      // Open stream
      System.out.println("Reading file  " + url.getFile());
      InputStream input = url.openStream();
      dataFile = new AsciiStreamReader(input);

      int num_val = num_x*num_y;
      for (int i = 0; i < num_val; i++)
        vm[which_dataset][i] = dataFile.readNextFloat();

      input.close();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
}
