package meshviz.mesh.advanced.meshViewer;

import java.awt.event.*;

import javax.swing.*;

import java.io.*;

public class AltitudePanel extends RepresentNodePanel {
  private AltitudeNode m_node;
  public JComboBox<String> m_datasetUsed;

  public AltitudePanel(AltitudeNode node) {
    super(node, node.toString());
    m_node = node;

    try {
      File help_file = new File(MeshViewer.m_filePrefix + "data/AltitudeHelp.htm");
      m_helpPage = help_file.toURI().toURL();

      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    m_visibilityButton.setToolTipText("Altitude visibility");
    m_pickableButton.setEnabled(false);

    JLabel dataset_used_label = new JLabel("Dataset used");
    String[] box_items = new String[m_node.m_datasetNames.length];
    for (int i = 0; i < box_items.length; i++)
      box_items[i] = m_node.m_datasetNames[i];
    m_datasetUsed = new JComboBox<String>(box_items);
    m_datasetUsed.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        m_node.setDatasetUsed((short)m_datasetUsed.getSelectedIndex());
      }
    });

    add(dataset_used_label);
    add(m_datasetUsed);
    m_spLayout.putConstraint(SpringLayout.NORTH, dataset_used_label,
                             NORTH_CONSTRAINT+3,
                             SpringLayout.NORTH, this);
    m_spLayout.putConstraint(SpringLayout.WEST, dataset_used_label, 5,
                             SpringLayout.WEST, this);
    m_spLayout.putConstraint(SpringLayout.NORTH, m_datasetUsed,
                             NORTH_CONSTRAINT,
                             SpringLayout.NORTH, this);
    m_spLayout.putConstraint(SpringLayout.WEST, m_datasetUsed, 15,
                             SpringLayout.EAST, dataset_used_label);
    m_spLayout.putConstraint(SpringLayout.SOUTH, this, SOUTH_CONSTRAINT,
                             SpringLayout.SOUTH, m_datasetUsed);
  }
}
