package meshviz.mesh.advanced.meshViewer;

import javax.swing.*;

import java.awt.*;
import java.awt.event.*;

import javax.swing.border.*;

import com.openinventor.inventor.*;
import com.openinventor.inventor.draggers.*;
import com.openinventor.inventor.nodes.*;

public class DraggerPanel extends JPanel {
  private final String[] ORIENT_BOX_ITEMS = {
      "X", "Y", "Z"
  };

  JCheckBox m_draggerOn;
  JButton m_draggerResetSize;
  JComboBox<String> m_draggerOrient;

  private SoJackDragger m_dragger;
  private SoSwitch m_draggerSwitch;
  private float m_scaleFactor;

  public DraggerPanel(SoJackDragger dragger, SoSwitch dragger_switch,
                      float scale_factor) {
    m_dragger = dragger;
    m_draggerSwitch = dragger_switch;
    m_scaleFactor = scale_factor;

    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    // Visibility
    m_draggerOn = new JCheckBox("Visible");
    m_draggerOn.addItemListener(new DraggerVisibilityListener());

    // Reset size
    m_draggerResetSize = new JButton("Reset Size");
    m_draggerResetSize.setEnabled(false);
    m_draggerResetSize.setBorder(BorderFactory.createRaisedBevelBorder());
    m_draggerResetSize.setPreferredSize(new Dimension(80, 25));
    m_draggerResetSize.addMouseListener(new DraggerResetSizeListener());

    // Orientation
    JLabel orient_label = new JLabel("Orientation");
    m_draggerOrient = new JComboBox<String>(ORIENT_BOX_ITEMS);
    m_draggerOrient.setSelectedIndex(2);
    m_draggerOrient.addActionListener(new DraggerOrientListener());

    SpringLayout sp_layout = new SpringLayout();
    setLayout(sp_layout);
    TitledBorder tb = new TitledBorder(BorderFactory.createRaisedBevelBorder(),
                                        "Dragger");
    tb.setTitleJustification(TitledBorder.LEFT);
    setBorder(tb);
    add(m_draggerOn);
    add(orient_label);
    add(m_draggerOrient);
    add(m_draggerResetSize);
    sp_layout.putConstraint(SpringLayout.NORTH, m_draggerOn,
                            RepresentNodePanel.NORTH_INNER_PANEL_CONSTRAINT,
                            SpringLayout.NORTH, this);
    sp_layout.putConstraint(SpringLayout.NORTH, orient_label, 13,
                            SpringLayout.SOUTH, m_draggerOn);
    sp_layout.putConstraint(SpringLayout.WEST, orient_label, 5,
                            SpringLayout.WEST, this);
    sp_layout.putConstraint(SpringLayout.NORTH, m_draggerOrient, 10,
                            SpringLayout.SOUTH, m_draggerOn);
    sp_layout.putConstraint(SpringLayout.WEST, m_draggerOrient, 20,
                            SpringLayout.EAST, orient_label);
    sp_layout.putConstraint(SpringLayout.NORTH, m_draggerResetSize, 10,
                            SpringLayout.SOUTH, m_draggerOn);
    sp_layout.putConstraint(SpringLayout.WEST, m_draggerResetSize, 35,
                            SpringLayout.EAST, m_draggerOrient);
    sp_layout.putConstraint(SpringLayout.EAST, this, 202,
                            SpringLayout.EAST, m_draggerResetSize);
    sp_layout.putConstraint(SpringLayout.SOUTH, this,
                            RepresentNodePanel.SOUTH_CONSTRAINT,
                            SpringLayout.SOUTH, m_draggerOrient);

  }

  class DraggerVisibilityListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED) {
        m_draggerSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
        m_draggerResetSize.setEnabled(true);
      }
      else {
        m_draggerSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
        m_draggerResetSize.setEnabled(false);
      }
    }
  }

  class DraggerOrientListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      if (m_dragger instanceof SoJackDragger) {
        int selected_index = m_draggerOrient.getSelectedIndex();
        SbVec3f dragger_normal = new SbVec3f();
        switch (selected_index) {
          case 0:
            dragger_normal.setValue(1, 0, 0);
            break;
          case 1:
            dragger_normal.setValue(0, 1, 0);
            break;
          case 2:
            dragger_normal.setValue(0, 0, 1);
            break;
        }
        m_dragger.rotation.setValue(new SbRotation(new SbVec3f(0, 1, 0),
                                                   dragger_normal));
      }
    }
  }

  class DraggerResetSizeListener extends MouseAdapter {
    public void mouseReleased(MouseEvent e) {
      if (m_draggerResetSize.isEnabled()) {
        m_dragger.scaleFactor.setValue(m_scaleFactor,
                                       m_scaleFactor,
                                       m_scaleFactor);
      }
    }
  }
}
