package meshviz.mesh.advanced.meshViewer;

import com.openinventor.inventor.nodes.*;
import com.openinventor.meshviz.data.*;

public class Mesh2DNode extends MeshNode {
  private String m_name;
  private SoSeparator m_scalar2DSep;

  public Mesh2DNode(MeshViewer mesh_viewer) {
    m_name = "Mesh 2D";

    m_scalar2DSep = new SoSeparator();
    if (mesh_viewer.m_domain != null)
      m_scalar2DSep.addChild(mesh_viewer.m_domain);

    {
      m_meshSep = new SoSeparator();
      m_meshSep.addChild(new SoPolygonOffset());
      m_meshSep.addChild(m_scalar2DSep);
    }
    mesh_viewer.m_scene3D.addChild(m_meshSep);
  }

  // Vector 2D
  public void addVecField(Mesh2DVecFieldNode vf_node) {
    vf_node.m_mesh2DVecField.bodyColoringType.setValue(PoMesh2DVec.ArrowColoringTypes.CONSTANT_COLOR);
    m_meshSep.addChild(vf_node.m_mesh2DVecFieldSwitch);
  }

  public void removeVecField(Mesh2DVecFieldNode vf_node) {
    m_meshSep.removeChild(vf_node.m_mesh2DVecFieldSwitch);
  }

  // Scalar 2D
  public void addMeshLines(MeshLinesNode ml_node) {
    m_scalar2DSep.addChild(ml_node.m_meshLinesSwitch);
  }

  public void removeMeshLines(MeshLinesNode ml_node) {
    m_scalar2DSep.removeChild(ml_node.m_meshLinesSwitch);
  }

  public void addMeshFilled(MeshFilledNode mf_node) {
    mf_node.m_meshFilled.coloringType.setValue(PoMesh.ColoringTypes.COLOR_INHERITED);
    m_scalar2DSep.addChild(mf_node.m_meshFilledSwitch);
  }

  public void removeMeshFilled(MeshFilledNode mf_node) {
    m_scalar2DSep.removeChild(mf_node.m_meshFilledSwitch);
  }

  public void addMeshLimit(MeshLimitNode ml_node) {
    m_scalar2DSep.addChild(ml_node.m_meshLimitSwitch);
  }

  public void removeMeshLimit(MeshLimitNode ml_node) {
    m_scalar2DSep.removeChild(ml_node.m_meshLimitSwitch);
  }

  public void addMeshSides(MeshSidesNode ms_node) {
    m_scalar2DSep.addChild(ms_node.m_meshSidesSwitch);
  }

  public void removeMeshSides(MeshSidesNode ms_node) {
    m_scalar2DSep.removeChild(ms_node.m_meshSidesSwitch);
  }

  public String toString() {
    return m_name;
  }
}


