package meshviz.mesh.advanced.meshViewer;

import com.openinventor.inventor.*;
import com.openinventor.meshviz.data.*;
import com.openinventor.inventor.nodes.*;

public class Mesh2DVecFieldNode extends Vector2DRepresentNode {
  PoMesh2DVec m_mesh2DVecField;
  SoSwitch m_mesh2DVecFieldSwitch;

  private SoNode[] m_inventorNodes;
  private String m_name;
  private Mesh2DVecFieldPanel m_panel;
  private Vector2DNode m_parent;
  public float m_scaleFactor;
  public PbMesh m_mesh;

  public Mesh2DVecFieldNode(PbMesh mesh, SbBox3f bbox) {
    m_name = "Vector Field";
    m_mesh = mesh;

    float[] bbox_size = bbox.getSize().array;
    float max = bbox_size[0];
    if (bbox_size[1] > max)
      max = bbox_size[1];
    if (bbox_size[2] > max)
      max = bbox_size[2];

    float vec_length_factor = 0.05f * max;

    // define the vector field
    m_mesh2DVecField = new PoMesh2DVec();
    m_mesh2DVecField.bodyLengthFactor.setValue(vec_length_factor);
    m_mesh2DVecField.bodyLengthType.setValue(PoMesh2DVec.BodyLengthTypes.CONSTANT_LENGTH);
    m_mesh2DVecField.endArrowHeightFactor.setValue(0.25f);

    {
      SoSeparator mesh2DVecField_sep = new SoSeparator();
      mesh2DVecField_sep.addChild(m_pickSwitch);
      mesh2DVecField_sep.addChild(m_mesh2DVecField);

      m_mesh2DVecFieldSwitch = new SoSwitch();
      m_mesh2DVecFieldSwitch.addChild(mesh2DVecField_sep);
      m_mesh2DVecFieldSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    }

    m_panel = new Mesh2DVecFieldPanel(this);
    m_inventorNodes = new SoNode[]{m_mesh2DVecField};
  }

  public String toString() {
    return m_name;
  }

  public RepresentNodePanel getPanel() {
    return m_panel;
  }

  public SoNode[] addToParent(DataNode parent, boolean is_drop_action) {
    m_parent = (Vector2DNode)parent;
    m_parent.addVecField(this);

    return m_inventorNodes;
  }

  public SoNode[] delete(boolean is_drop_action) {
    m_parent.removeVecField(this);
    return m_inventorNodes;
  }

  public void show(boolean show) {
    if (show)
      m_mesh2DVecFieldSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    else
      m_mesh2DVecFieldSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
  }

  public DataNode getDataNodeParent() {
    return m_parent;
  }
}
