package meshviz.mesh.advanced.meshViewer;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

public class Mesh2DVecFieldPanel extends RepresentNodePanel {
  private final String[] TYPE_ITEMS = {
    "No Shape", "Point", "Chevron", "Triangle"
  };
  private final String[] HEIGHT_ITEMS = {
    "Constant", "Relative   "
  };

  Mesh2DVecFieldNode m_node;

  public Mesh2DVecFieldPanel(Mesh2DVecFieldNode node) {
    super(node, node.toString());
    m_node = node;

    try {
      File help_file = new File(MeshViewer.m_filePrefix + "data/Mesh2DVecHelp.htm");
      m_helpPage = help_file.toURI().toURL();

      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    m_visibilityButton.setToolTipText("Vector field visibility");

    // Vectors length
    float body_length_factor = m_node.m_mesh2DVecField.bodyLengthFactor.getValue();
    SliderPanel vec_length = new SliderPanel(0,
                                             body_length_factor*2.f,
                                             body_length_factor,
                                             3);
    vec_length.addInfoText("Vectors' length");
    vec_length.addSliderPanelListener(new SliderPanel.Listener() {
      public void stateChanged(float value) {
        m_node.m_mesh2DVecField.bodyLengthFactor.setValue(value);
      }
    });

    // End arrow panel
    JLabel end_arrow_shape_label = new JLabel("Arrow Shape");
    final JComboBox<String> end_arrow_shape = new JComboBox<String>(TYPE_ITEMS);
    end_arrow_shape.setSelectedIndex(m_node.m_mesh2DVecField.endArrowShape.getValue());
    end_arrow_shape.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        int selected_index = end_arrow_shape.getSelectedIndex();
        m_node.m_mesh2DVecField.endArrowShape.setValue(selected_index);
      }
    });

    JLabel end_arrow_height_label = new JLabel("Height Type");
    final JComboBox<String> end_arrow_height_type = new JComboBox<String>(HEIGHT_ITEMS);
    end_arrow_height_type.setSelectedIndex(m_node.m_mesh2DVecField.endArrowHeightType.getValue());
    end_arrow_height_type.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        int selected_index = end_arrow_height_type.getSelectedIndex();
        m_node.m_mesh2DVecField.endArrowHeightType.setValue(selected_index);
      }
    });

    Dimension label_dim = new Dimension(85, 20);
    float ea_height_factor = m_node.m_mesh2DVecField.endArrowHeightFactor.getValue();
    SliderPanel end_arrow_height = new SliderPanel(0,
                                                   ea_height_factor*2.f,
                                                   ea_height_factor,
                                                   3);
    end_arrow_height.addInfoText("Height");
    end_arrow_height.setInfoTextSize(label_dim);
    end_arrow_height.addSliderPanelListener(new SliderPanel.Listener() {
      public void stateChanged(float value) {
        m_node.m_mesh2DVecField.endArrowHeightFactor.setValue(value);
      }
    });

    float ea_radius_factor = m_node.m_mesh2DVecField.endArrowRadiusFactor.getValue();
    SliderPanel end_arrow_radius = new SliderPanel(0,
                                                   ea_radius_factor*2.f,
                                                   ea_radius_factor,
                                                   3);
    end_arrow_radius.addInfoText("Radius");
    end_arrow_radius.setInfoTextSize(label_dim);
    end_arrow_radius.addSliderPanelListener(new SliderPanel.Listener() {
      public void stateChanged(float value) {
        m_node.m_mesh2DVecField.endArrowRadiusFactor.setValue(value);
      }
    });

    SpringLayout eap_layout = new SpringLayout();
    JPanel end_arrow_panel = new JPanel(eap_layout);
    TitledBorder eap_border = new TitledBorder(BorderFactory.createRaisedBevelBorder(),
                                               "End Arrow");
    end_arrow_panel.setBorder(eap_border);
    end_arrow_panel.add(end_arrow_shape_label);
    end_arrow_panel.add(end_arrow_shape);
    end_arrow_panel.add(end_arrow_height_label);
    end_arrow_panel.add(end_arrow_height_type);
    end_arrow_panel.add(end_arrow_height);
    end_arrow_panel.add(end_arrow_radius);
    eap_layout.putConstraint(SpringLayout.NORTH, end_arrow_shape_label,
                             NORTH_INNER_PANEL_CONSTRAINT+3,
                             SpringLayout.NORTH, end_arrow_panel);
    eap_layout.putConstraint(SpringLayout.WEST, end_arrow_shape_label, 5,
                             SpringLayout.WEST, end_arrow_panel);
    eap_layout.putConstraint(SpringLayout.NORTH, end_arrow_shape,
                             NORTH_INNER_PANEL_CONSTRAINT,
                             SpringLayout.NORTH, end_arrow_panel);
    eap_layout.putConstraint(SpringLayout.WEST, end_arrow_shape, 20,
                             SpringLayout.EAST, end_arrow_shape_label);
    eap_layout.putConstraint(SpringLayout.NORTH, end_arrow_height_label,
                             VERT_SPACE_CONSTRAINT+3,
                             SpringLayout.SOUTH, end_arrow_shape);
    eap_layout.putConstraint(SpringLayout.WEST, end_arrow_height_label, 5,
                             SpringLayout.WEST, end_arrow_panel);
    eap_layout.putConstraint(SpringLayout.NORTH, end_arrow_height_type,
                             VERT_SPACE_CONSTRAINT,
                             SpringLayout.SOUTH, end_arrow_shape);
    eap_layout.putConstraint(SpringLayout.WEST, end_arrow_height_type, 28,
                             SpringLayout.EAST, end_arrow_height_label);
    eap_layout.putConstraint(SpringLayout.NORTH, end_arrow_height,
                             VERT_SPACE_CONSTRAINT,
                             SpringLayout.SOUTH, end_arrow_height_type);
    eap_layout.putConstraint(SpringLayout.NORTH, end_arrow_radius,
                             VERT_SPACE_CONSTRAINT,
                             SpringLayout.SOUTH, end_arrow_height);
    eap_layout.putConstraint(SpringLayout.SOUTH, end_arrow_panel,
                             SOUTH_CONSTRAINT,
                             SpringLayout.SOUTH, end_arrow_radius);
    eap_layout.putConstraint(SpringLayout.EAST, end_arrow_panel, 49,
                             SpringLayout.EAST, end_arrow_radius);

    // Main panel
    add(vec_length);
    add(end_arrow_panel);
    m_spLayout.putConstraint(SpringLayout.NORTH, vec_length, NORTH_CONSTRAINT,
                             SpringLayout.NORTH, this);
    m_spLayout.putConstraint(SpringLayout.WEST, vec_length, 5,
                             SpringLayout.WEST, this);
    m_spLayout.putConstraint(SpringLayout.NORTH, end_arrow_panel, 15,
                             SpringLayout.SOUTH, vec_length);
    m_spLayout.putConstraint(SpringLayout.SOUTH, this, SOUTH_CONSTRAINT,
                             SpringLayout.SOUTH, end_arrow_panel);
  }
}
