package meshviz.mesh.advanced.meshViewer;

import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.meshviz.data.PoMeshContouring;

public class MeshContouringNode extends Scalar2DRepresentNode {
  PoMeshContouring m_meshContouring;
  SoSwitch m_meshContouringSwitch;
  SoSwitch m_isoValuesSwitch;

  private SoNode[] m_inventorNodes;
  private String m_name;
  private MeshContouringPanel m_panel;
  private Scalar2DNode m_parent;

  public MeshContouringNode(SoSwitch iso_values_switch) {
    m_name = "Mesh Contouring";
    m_isoValuesSwitch = (SoSwitch)iso_values_switch.copy();

    m_meshContouring = new PoMeshContouring();
    m_meshContouring.annotGap.setValue(.3f);
    m_meshContouring.annotIsContourClip.setValue(true);
    m_meshContouring.set("minorContourLineApp.drawStyle", "linePattern 0xF0F0");
    m_meshContouring.set("annotTextApp.material", "diffuseColor 1. 1. 1.");
    m_meshContouring.set("annotBackgroundApp.material", "diffuseColor 0.4 0.4 0.4");
    m_meshContouring.set("annotBackgroundBorderApp.material", "diffuseColor 1 1 1");
    m_meshContouring.zValuesIndex.setValue(m_zDatasetIndex);

    {
      SoSeparator meshContouring_sep = new SoSeparator();
      meshContouring_sep.addChild(m_pickSwitch);
      meshContouring_sep.addChild(m_isoValuesSwitch);
      meshContouring_sep.addChild(m_meshContouring);

      m_meshContouringSwitch = new SoSwitch();
      m_meshContouringSwitch.addChild(meshContouring_sep);
      m_meshContouringSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    }

    m_panel = new MeshContouringPanel(this);
    m_inventorNodes = new SoNode[]{m_meshContouring};
  }

  public void updateZDatasetIndex() {
    m_meshContouring.zValuesIndex.setValue(m_zDatasetIndex);
  }

  public String toString() {
    return m_name;
  }

  public RepresentNodePanel getPanel() {
    return m_panel;
  }

  public SoNode[] addToParent(DataNode parent, boolean is_drop_action) {
    m_parent = (Scalar2DNode)parent;
    m_parent.addMeshContouring(this);

    if (! is_drop_action)
      m_poMesh2DNodes.add(this);

    return m_inventorNodes;
  }

  public SoNode[] delete(boolean is_drop_action) {
    m_parent.removeMeshContouring(this);

    if (! is_drop_action)
      m_poMesh2DNodes.remove(this);

    return m_inventorNodes;
  }

  public void show(boolean show) {
    if (show)
      m_meshContouringSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    else
      m_meshContouringSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
  }

  public DataNode getDataNodeParent() {
    return m_parent;
  }
}
