package meshviz.mesh.advanced.meshViewer;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;

import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;
import com.openinventor.meshviz.data.PoMesh;

public class MeshContouringPanel extends RepresentNodePanel {
  private final String[] PATH_ITEMS = {
    "Tangential", "Horizontal", "Vertical"
  };
  private final String[] CROSSING_ITEMS = {
    "Any contour", "Minor contour", "None"
  };

  private MeshContouringNode m_node;

  public MeshContouringPanel(MeshContouringNode node) {
    super(node, node.toString());
    m_node = node;

    try {
      File help_file = new File(MeshViewer.m_filePrefix + "data/MeshContouringHelp.htm");
      m_helpPage = help_file.toURI().toURL();

      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    m_visibilityButton.setToolTipText("Contour visibility");

    // Color box
    JCheckBox colored_box = new JCheckBox("Colored");
    colored_box.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == ItemEvent.SELECTED)
          m_node.m_meshContouring.coloringType.setValue(PoMesh.ColoringTypes.COLOR_MAPPING);
        else
          m_node.m_meshContouring.coloringType.setValue(PoMesh.ColoringTypes.COLOR_INHERITED);
      }
    });
    colored_box.setSelected(true);

    // Annotation panel
    JCheckBox visible = new JCheckBox("Visible");
    visible.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        m_node.m_meshContouring.annotIsVisible.
            setValue(e.getStateChange() == ItemEvent.SELECTED);
      }
    });

    JCheckBox background = new JCheckBox("Background");
    background.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        m_node.m_meshContouring.annotIsBackground.
            setValue(e.getStateChange() == ItemEvent.SELECTED);
      }
    });

    JLabel path_label = new JLabel("Path");
    final JComboBox<String> path = new JComboBox<String>(PATH_ITEMS);
    path.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        int selected_index = path.getSelectedIndex();
        m_node.m_meshContouring.annotPath.setValue(selected_index);
      }
    });

    JLabel crossing_label = new JLabel("Crossing...");
    final JComboBox<String> crossing = new JComboBox<String>(CROSSING_ITEMS);
    crossing.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        int selected_index = crossing.getSelectedIndex();
        m_node.m_meshContouring.annotCrossStatus.setValue(selected_index);
      }
    });

    Dimension label_dim = new Dimension(73, 20);
    SliderPanel gap = new SliderPanel(0, 1.f,
                                      m_node.m_meshContouring.annotGap.getValue(),
                                      3);
    gap.addInfoText("Gap");
    gap.setInfoTextSize(label_dim);
    gap.addSliderPanelListener(new SliderPanel.Listener() {
      public void stateChanged(float value) {
        m_node.m_meshContouring.annotGap.setValue(value);
      }
    });

    SliderPanel font_size = new SliderPanel(0, 0.1f,
                                            m_node.m_meshContouring.annotFontSize.getValue(),
                                            3);
    font_size.addInfoText("Font size");
    font_size.setInfoTextSize(label_dim);
    font_size.addSliderPanelListener(new SliderPanel.Listener() {
      public void stateChanged(float value) {
        m_node.m_meshContouring.annotFontSize.setValue(value);
      }
    });


    SpringLayout ap_layout = new SpringLayout();
    JPanel annot_panel = new JPanel(ap_layout);
    TitledBorder ap_border = new TitledBorder(BorderFactory.createRaisedBevelBorder(),
                                               "Contours Annot");
    annot_panel.setBorder(ap_border);
    annot_panel.add(visible);
    annot_panel.add(background);
    annot_panel.add(path_label);
    annot_panel.add(path);
    annot_panel.add(crossing_label);
    annot_panel.add(crossing);
    annot_panel.add(gap);
    annot_panel.add(font_size);
    ap_layout.putConstraint(SpringLayout.NORTH, visible,
                            NORTH_INNER_PANEL_CONSTRAINT,
                            SpringLayout.NORTH, annot_panel);
    ap_layout.putConstraint(SpringLayout.NORTH, background,
                            NORTH_INNER_PANEL_CONSTRAINT,
                            SpringLayout.NORTH, annot_panel);
    ap_layout.putConstraint(SpringLayout.WEST, background, 20,
                            SpringLayout.EAST, visible);

    ap_layout.putConstraint(SpringLayout.NORTH, path_label, 13,
                            SpringLayout.SOUTH, visible);
    ap_layout.putConstraint(SpringLayout.WEST, path_label, 5,
                            SpringLayout.WEST, annot_panel);
    ap_layout.putConstraint(SpringLayout.NORTH, path, 10,
                            SpringLayout.SOUTH, visible);
    ap_layout.putConstraint(SpringLayout.WEST, path, 56,
                            SpringLayout.EAST, path_label);

    ap_layout.putConstraint(SpringLayout.NORTH, crossing_label, 13,
                            SpringLayout.SOUTH, path);
    ap_layout.putConstraint(SpringLayout.WEST, crossing_label, 5,
                            SpringLayout.WEST, annot_panel);
    ap_layout.putConstraint(SpringLayout.NORTH, crossing, 10,
                            SpringLayout.SOUTH, path);
    ap_layout.putConstraint(SpringLayout.WEST, crossing, 22,
                            SpringLayout.EAST, crossing_label);

    ap_layout.putConstraint(SpringLayout.NORTH, gap,
                            VERT_SPACE_CONSTRAINT,
                            SpringLayout.SOUTH, crossing);
    ap_layout.putConstraint(SpringLayout.NORTH, font_size,
                            VERT_SPACE_CONSTRAINT,
                            SpringLayout.SOUTH, gap);

    ap_layout.putConstraint(SpringLayout.SOUTH, annot_panel,
                            SOUTH_CONSTRAINT,
                            SpringLayout.SOUTH, font_size);
    ap_layout.putConstraint(SpringLayout.EAST, annot_panel, 61,
                            SpringLayout.EAST, font_size);

    // Main panel
    add(colored_box);
    add(annot_panel);
    m_spLayout.putConstraint(SpringLayout.NORTH, colored_box, NORTH_CONSTRAINT,
                             SpringLayout.NORTH, this);
    m_spLayout.putConstraint(SpringLayout.WEST, colored_box, 5,
                             SpringLayout.WEST, this);
    m_spLayout.putConstraint(SpringLayout.NORTH, annot_panel, 15,
                             SpringLayout.SOUTH, colored_box);
    m_spLayout.putConstraint(SpringLayout.SOUTH, this, SOUTH_CONSTRAINT,
                             SpringLayout.SOUTH, annot_panel);
  }
}
