package meshviz.mesh.advanced.meshViewer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

public class MeshFilledPanel extends RepresentNodePanel {
  private MeshFilledNode m_node;

  public MeshFilledPanel(MeshFilledNode node) {
    super(node, node.toString(), true, true);
    m_node = node;

    try {
      File help_file = new File(MeshViewer.m_filePrefix + "data/MeshFilledHelp.htm");
      m_helpPage = help_file.toURI().toURL();

      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    m_visibilityButton.setToolTipText("Mesh Filled visibility");

    m_transparencySlider.addSliderPanelListener(new SliderPanel.Listener() {
      public void stateChanged(float value) {
        m_node.setTransparency(value);
      }
    });

    m_coloringModeBox.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        int selected_index = m_coloringModeBox.getSelectedIndex();
         m_node.m_meshFilled.coloringType.setValue(selected_index);
         m_node.m_whichColoringType = selected_index;
      }
    });
    m_coloringModeBox.setSelectedIndex(2);
  }
}
