package meshviz.mesh.advanced.meshViewer;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SpringLayout;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

public class MeshLevelSurfPanel extends RepresentNodePanel {
  private MeshLevelSurfNode m_node;
  private SliderPanel m_isoValueSlider;
  private JComboBox<String> m_datasetBox;
  private DatasetUsedListener m_dul;

  public MeshLevelSurfPanel(MeshLevelSurfNode node) {
    super(node, node.toString(), true, true);
    m_node = node;

    try {
      File help_file = new File(MeshViewer.m_filePrefix + "data/MeshLevelSurfHelp.htm");
      m_helpPage = help_file.toURI().toURL();

      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    m_visibilityButton.setToolTipText("Mesh Level Surface visibility");

    m_transparencySlider.addSliderPanelListener(new SliderPanel.Listener() {
      public void stateChanged(float value) {
        m_node.setTransparency(value);
      }
    });

    m_coloringModeBox.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        int selected_index = m_coloringModeBox.getSelectedIndex();
        m_node.m_meshLevelSurf.coloringType.setValue(selected_index);
        m_node.m_whichColoringType = selected_index;
      }
    });
    m_coloringModeBox.setSelectedIndex(2);

    // dataset used
    String[] box_items = new String[m_node.m_datasetNames.length];
    for (int i = 0; i < box_items.length; i++)
      box_items[i] = m_node.m_datasetNames[i];
    m_datasetBox = new JComboBox<String>(box_items);
    m_dul = new DatasetUsedListener();
    m_datasetBox.addActionListener(m_dul);
    JLabel dataset_label = new JLabel("Dataset Used");

    // Iso value
    m_isoValueSlider = new SliderPanel(0.f, 0.f, 0.f, 3);
    m_isoValueSlider.addInfoText("Iso Value");
    m_isoValueSlider.setInfoTextSize(new Dimension(85, 20));
    m_isoValueSlider.addSliderPanelListener(new IsoValueListener());

    add(dataset_label);
    add(m_datasetBox);
    add(m_isoValueSlider);
    m_spLayout.putConstraint(SpringLayout.WEST, dataset_label, 10,
                             SpringLayout.WEST, this);
    m_spLayout.putConstraint(SpringLayout.NORTH, dataset_label, 33,
                             SpringLayout.SOUTH, m_coloringModeBox);
    m_spLayout.putConstraint(SpringLayout.NORTH, m_datasetBox, 30,
                             SpringLayout.SOUTH, m_coloringModeBox);
    m_spLayout.putConstraint(SpringLayout.WEST, m_datasetBox, 18,
                             SpringLayout.EAST, dataset_label);
    m_spLayout.putConstraint(SpringLayout.NORTH, m_isoValueSlider, 15,
                             SpringLayout.SOUTH, m_datasetBox);
    m_spLayout.putConstraint(SpringLayout.WEST, m_isoValueSlider, 5,
                             SpringLayout.WEST, this);
    m_spLayout.putConstraint(SpringLayout.SOUTH, this, SOUTH_CONSTRAINT,
                             SpringLayout.SOUTH, m_isoValueSlider);
  }

  public void update(int which_dataset, float min, float max, float value) {
    m_datasetBox.removeActionListener(m_dul);
    m_datasetBox.setSelectedIndex(which_dataset);
    m_datasetBox.addActionListener(m_dul);
    m_isoValueSlider.setSliderMin(min);
    m_isoValueSlider.setSliderMax(max);
    m_isoValueSlider.setSliderValue(value);

  }

  class DatasetUsedListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      int selected_index = ((JComboBox<?>)e.getSource()).getSelectedIndex();
      m_node.setDatasetUsed(selected_index);
    }
  }

  class IsoValueListener extends SliderPanel.Listener {
    public void stateChanged(float value) {
      m_node.m_meshLevelSurf.levelValue.setValue(value);
    }
  }
}
