package meshviz.mesh.advanced.meshViewer;

import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.meshviz.data.PoMesh;

public class MeshNode extends DataNode {
  protected SoSeparator m_meshSep;

  // probe
  public void addMeshProbe(MeshProbeNode mp_node) {
    mp_node.m_cellFacets.coloringType.setValue(PoMesh.ColoringTypes.COLOR_INHERITED);
    m_meshSep.addChild(mp_node.m_meshProbeSep);
  }

  public void removeMeshProbe(MeshProbeNode mp_node) {
    m_meshSep.removeChild(mp_node.m_meshProbeSep);
  }

  // stream
  public void addStream(MeshStreamNode ms_node) {
    ms_node.m_meshStreamLineParticle.coloringType.setValue(PoMesh.ColoringTypes.COLOR_INHERITED);
    ms_node.m_meshStreamLines.coloringType.setValue(PoMesh.ColoringTypes.COLOR_INHERITED);
    ms_node.m_meshStreamPoint.coloringType.setValue(PoMesh.ColoringTypes.COLOR_INHERITED);
    ms_node.m_meshStreamSphere.coloringType.setValue(PoMesh.ColoringTypes.COLOR_INHERITED);
    ms_node.m_meshStreamSurface.coloringType.setValue(PoMesh.ColoringTypes.COLOR_INHERITED);
    ms_node.m_meshStreamTadpole.coloringType.setValue(PoMesh.ColoringTypes.COLOR_INHERITED);
    m_meshSep.addChild(ms_node.m_meshStreamSep);
  }

  public void removeStream(MeshStreamNode ms_node) {
    m_meshSep.removeChild(ms_node.m_meshStreamSep);
  }

  public int getWhichDataset() {
    return -1;
  }
}
