package meshviz.mesh.advanced.meshViewer;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;

import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;

import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

public class MeshProbePanel extends RepresentNodePanel {
  private static final int VERT_BOX_SPACE_CONSTRAINT = 10;

  private MeshProbeNode m_node;
  private SliderPanel m_indicesOffset;

  public MeshProbePanel(MeshProbeNode node) {
    super(node, node.toString());
    m_node = node;

    try {
      File help_file = new File(MeshViewer.m_filePrefix + "data/MeshProbeHelp.htm");
      m_helpPage = help_file.toURI().toURL();

      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    m_visibilityButton.setToolTipText("Mesh Probe visibility");

    // Dragger panel
    DraggerPanel dragger_panel = new DraggerPanel(m_node.m_probeDragger,
                                                  m_node.m_probeDraggerSwitch,
                                                  m_node.m_scaleFactor);
    dragger_panel.m_draggerOn.setSelected(true);

    // Probe's link panel
    JCheckBox mouse_motion = new JCheckBox("Mouse's motion");
    mouse_motion.addItemListener(new ItemListener(){
      public void itemStateChanged(ItemEvent e) {
        boolean state = (e.getStateChange() == ItemEvent.SELECTED);
        m_node.connectProbeToMouseMotion(state);
      }
    });
    JCheckBox dragger_motion = new JCheckBox("Dragger's motion");
    dragger_motion.addItemListener(new ItemListener(){
      public void itemStateChanged(ItemEvent e) {
        boolean state = (e.getStateChange() == ItemEvent.SELECTED);
        m_node.connectProbeToDraggerMotion(state);
      }
    });
    dragger_motion.setSelected(true);

    TitledBorder pl_border = new TitledBorder(BorderFactory.createRaisedBevelBorder(),
                                           "Probe's Link");
    pl_border.setTitleJustification(TitledBorder.LEFT);
    SpringLayout pl_layout = new SpringLayout();
    JPanel probe_link = new JPanel(pl_layout);
    probe_link.setBorder(pl_border);
    probe_link.add(mouse_motion);
    probe_link.add(dragger_motion);
    pl_layout.putConstraint(SpringLayout.NORTH, mouse_motion, NORTH_INNER_PANEL_CONSTRAINT,
                            SpringLayout.NORTH, probe_link);
    pl_layout.putConstraint(SpringLayout.NORTH, dragger_motion, VERT_BOX_SPACE_CONSTRAINT,
                            SpringLayout.SOUTH, mouse_motion);
    pl_layout.putConstraint(SpringLayout.SOUTH, probe_link, SOUTH_CONSTRAINT,
                            SpringLayout.SOUTH, dragger_motion);
    pl_layout.putConstraint(SpringLayout.EAST, probe_link, 318,
                            SpringLayout.EAST, dragger_motion);

    // Cell view panel
    JCheckBox cell_facets = new JCheckBox("Cell facets");
    cell_facets.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == ItemEvent.SELECTED)
          m_node.m_cellFacetsSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
        else
          m_node.m_cellFacetsSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
      }
    });
    cell_facets.setSelected(true);

    JCheckBox cell_edges = new JCheckBox("Cell edges");
    cell_edges.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == ItemEvent.SELECTED)
          m_node.m_cellEdgesSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
        else
          m_node.m_cellEdgesSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
      }
    });

    JCheckBox cell_indices = new JCheckBox("Cell indices");
    cell_indices.addItemListener(new CellIndicesListener());

    m_indicesOffset = new SliderPanel(0, 5.f,
                                      m_node.m_cellIndices.offset.getValue(),
                                      3);
    m_indicesOffset.addInfoText("Offset");
    m_indicesOffset.setEnabled(false);
    m_indicesOffset.addSliderPanelListener(new SliderPanel.Listener() {
      public void stateChanged(float value) {
        m_node.m_cellIndices.offset.setValue(value);
      }
    });

    TitledBorder cv_border = new TitledBorder(BorderFactory.createRaisedBevelBorder(),
                                              "Cell View");
    cv_border.setTitleJustification(TitledBorder.LEFT);
    SpringLayout cv_layout = new SpringLayout();
    JPanel cell_view = new JPanel(cv_layout);
    cell_view.setBorder(cv_border);
    cell_view.add(cell_facets);
    cell_view.add(cell_edges);
    cell_view.add(cell_indices);
    cell_view.add(m_indicesOffset);
    cv_layout.putConstraint(SpringLayout.NORTH, cell_facets, NORTH_INNER_PANEL_CONSTRAINT,
                            SpringLayout.NORTH, cell_view);
    cv_layout.putConstraint(SpringLayout.NORTH, cell_edges, VERT_BOX_SPACE_CONSTRAINT,
                            SpringLayout.SOUTH, cell_facets);
    cv_layout.putConstraint(SpringLayout.NORTH, cell_indices, VERT_BOX_SPACE_CONSTRAINT,
                            SpringLayout.SOUTH, cell_edges);
    cv_layout.putConstraint(SpringLayout.NORTH, m_indicesOffset, VERT_BOX_SPACE_CONSTRAINT-3,
                            SpringLayout.SOUTH, cell_edges);
    cv_layout.putConstraint(SpringLayout.WEST, m_indicesOffset, 6,
                            SpringLayout.EAST, cell_indices);
    cv_layout.putConstraint(SpringLayout.SOUTH, cell_view, SOUTH_CONSTRAINT,
                            SpringLayout.SOUTH, cell_indices);
    cv_layout.putConstraint(SpringLayout.EAST, cell_view, 5,
                            SpringLayout.EAST, m_indicesOffset);

    // Main panel
    add(dragger_panel);
    add(probe_link);
    add(cell_view);
    m_spLayout.putConstraint(SpringLayout.NORTH, dragger_panel, NORTH_CONSTRAINT,
                             SpringLayout.NORTH, this);
    m_spLayout.putConstraint(SpringLayout.NORTH, probe_link, VERT_SPACE_CONSTRAINT,
                             SpringLayout.SOUTH, dragger_panel);
    m_spLayout.putConstraint(SpringLayout.NORTH, cell_view, VERT_SPACE_CONSTRAINT,
                             SpringLayout.SOUTH, probe_link);
    m_spLayout.putConstraint(SpringLayout.SOUTH, this, SOUTH_CONSTRAINT,
                             SpringLayout.SOUTH, cell_view);
  }

  class CellIndicesListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED) {
        m_node.m_cellIndicesSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
        m_indicesOffset.setEnabled(true);
      } else {
        m_node.m_cellIndicesSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
        m_indicesOffset.setEnabled(false);
      }
    }
  }
}
