package meshviz.mesh.advanced.meshViewer;

import com.openinventor.meshviz.data.*;
import com.openinventor.inventor.nodes.*;

public class MeshSidesNode extends Scalar2DRepresentNode {
  PoMeshSides m_meshSides;
  SoSwitch m_meshSidesSwitch;

  private SoNode[] m_inventorNodes;
  private String m_name;
  private MeshSidesPanel m_panel;
  private Mesh2DNode m_parent;
  private PbMesh m_mesh;

  public MeshSidesNode(PbMesh mesh) {
    m_name = "Mesh Sides";
    m_mesh = mesh;

    m_meshSides = new PoMeshSides();
    m_meshSides.thresholdType.setValue(PoMeshSides.ThresholdTypes.THRESHOLD_VALUE);
    updateZDatasetIndex();

    {
      SoSeparator meshSides_sep = new SoSeparator();
      meshSides_sep.addChild(m_pickSwitch);
      meshSides_sep.addChild(m_meshSides);

      m_meshSidesSwitch = new SoSwitch();
      m_meshSidesSwitch.addChild(meshSides_sep);
      m_meshSidesSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    }

    m_panel = new MeshSidesPanel(this);
    m_inventorNodes = new SoNode[]{m_meshSides};
  }

  public void updateZDatasetIndex() {
    m_meshSides.zValuesIndex.setValue(m_zDatasetIndex);
    if (m_zDatasetIndex >=0) {
      float zmin = m_mesh.getMinValuesSet(m_zDatasetIndex);
      float zmax = m_mesh.getMaxValuesSet(m_zDatasetIndex);
      m_meshSides.thresholdValue.setValue(zmin-(zmax-zmin)/20);
    } else
      m_meshSides.thresholdValue.setValue(0);
  }

  public String toString() {
    return m_name;
  }

  public RepresentNodePanel getPanel() {
    return m_panel;
  }

  public SoNode[] addToParent(DataNode parent, boolean is_drop_action) {
    m_parent = (Mesh2DNode)parent;
    m_parent.addMeshSides(this);

    if (! is_drop_action)
      m_poMesh2DNodes.add(this);

    return m_inventorNodes;
  }

  public SoNode[] delete(boolean is_drop_action) {
    m_parent.removeMeshSides(this);

    if (! is_drop_action)
      m_poMesh2DNodes.remove(this);

    return m_inventorNodes;
  }

  public void show(boolean show) {
    if (show)
      m_meshSidesSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    else
      m_meshSidesSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
  }

  public DataNode getDataNodeParent() {
    return m_parent;
  }
}
