package meshviz.mesh.advanced.meshViewer;

import java.io.File;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

public class MeshSkeletonPanel extends RepresentNodePanel {
  private MeshSkeletonNode m_node;

  public MeshSkeletonPanel(MeshSkeletonNode node) {
    super(node, node.toString());
    m_node = node;

    try {
      File help_file = new File(MeshViewer.m_filePrefix + "data/MeshSkeletonHelp.htm");
      m_helpPage = help_file.toURI().toURL();

      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    m_visibilityButton.setToolTipText("Mesh Skeleton visibility");

    SliderPanel X_axis = new SliderPanel(0, 10, 3);
    X_axis.addInfoText("X Axis");
    X_axis.addSliderPanelListener(new SliderPanel.Listener() {
      public void stateChanged(float value) {
        m_node.m_meshSkeleton.numXContour.setValue((int) value);
      }
    });

    SliderPanel Y_axis = new SliderPanel(0, 10, 3);
    Y_axis.addInfoText("Y Axis");
    Y_axis.addSliderPanelListener(new SliderPanel.Listener() {
      public void stateChanged(float value) {
        m_node.m_meshSkeleton.numYContour.setValue((int) value);
      }
    });

    SliderPanel Z_axis = new SliderPanel(0, 10, 3);
    Z_axis.addInfoText("Z Axis");
    Z_axis.addSliderPanelListener(new SliderPanel.Listener() {
      public void stateChanged(float value) {
        m_node.m_meshSkeleton.numZContour.setValue((int) value);
      }
    });

    SpringLayout ccn_layout = new SpringLayout();
    JPanel cross_contours_number = new JPanel(ccn_layout);
    TitledBorder tb = new TitledBorder(BorderFactory.createRaisedBevelBorder(),
                                       "Cross-contours Number");
    tb.setTitleJustification(TitledBorder.LEFT);
    cross_contours_number.setBorder(tb);
    cross_contours_number.add(X_axis);
    cross_contours_number.add(Y_axis);
    cross_contours_number.add(Z_axis);
    ccn_layout.putConstraint(SpringLayout.NORTH, X_axis, NORTH_INNER_PANEL_CONSTRAINT,
                             SpringLayout.NORTH, cross_contours_number);
    ccn_layout.putConstraint(SpringLayout.NORTH, Y_axis, VERT_SPACE_CONSTRAINT,
                             SpringLayout.SOUTH, X_axis);
    ccn_layout.putConstraint(SpringLayout.NORTH, Z_axis, VERT_SPACE_CONSTRAINT,
                             SpringLayout.SOUTH, Y_axis);
    ccn_layout.putConstraint(SpringLayout.EAST, cross_contours_number, 122,
                             SpringLayout.EAST, X_axis);
    ccn_layout.putConstraint(SpringLayout.SOUTH, cross_contours_number, SOUTH_CONSTRAINT,
                             SpringLayout.SOUTH, Z_axis);

    add(cross_contours_number);
    m_spLayout.putConstraint(SpringLayout.NORTH, cross_contours_number,
                             NORTH_CONSTRAINT,
                             SpringLayout.NORTH, this);
    m_spLayout.putConstraint(SpringLayout.SOUTH, this, SOUTH_CONSTRAINT,
                             SpringLayout.SOUTH, cross_contours_number);
  }
}
