package meshviz.mesh.advanced.meshViewer;

import com.openinventor.inventor.nodes.SoDrawStyle;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoPolygonOffset;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.meshviz.data.PoMesh;
import com.openinventor.meshviz.data.PoMeshSkin;
import com.openinventor.meshviz.graph.PoBase;
import com.openinventor.meshviz.misc.callbacks.PoRebuildCB;

public class MeshSkinNode extends Scalar3DRepresentNode {
  PoMeshSkin m_meshSkin;
  SoSwitch m_meshSkinSwitch;
  SoSwitch m_coloredMeshSkinSwitch;
  SoSwitch m_meshSkinEdgeSwitch;
  SoSeparator m_meshSkinSep;

  public int m_whichColoringType;

  private SoNode[] m_inventorNodes;
  private String m_name;
  private int m_number;
  private MeshSkinPanel m_panel;
  private float m_transparencyValue;
  private DataNode m_parent;

  public MeshSkinNode() {
    m_number = m_skinVector.size()+1;
    m_name = "Mesh Skin " + m_number;
    m_transparencyValue = 0.f;
    m_whichColoringType = PoMesh.ColoringTypes.COLOR_MAPPING.getValue();

    // mesh skin
    m_meshSkin = new PoMeshSkin();
    m_meshSkin.addPostRebuildCallback(new TransparencyCB(), null);
    m_coloredMeshSkinSwitch = new SoSwitch();
    {
      m_coloredMeshSkinSwitch.addChild(new SoPolygonOffset());
      m_coloredMeshSkinSwitch.addChild(m_meshSkin);
      m_coloredMeshSkinSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    }

    // mesh skin edges
    SoDrawStyle skin_style = new SoDrawStyle();
    skin_style.style.setValue(SoDrawStyle.Styles.LINES);
    PoMeshSkin mesh_skin_edge = new PoMeshSkin();
    mesh_skin_edge.coloringType.setValue(PoMesh.ColoringTypes.COLOR_INHERITED);
    m_meshSkinEdgeSwitch = new SoSwitch();
    {
      m_meshSkinEdgeSwitch.addChild(skin_style);
      m_meshSkinEdgeSwitch.addChild(mesh_skin_edge);
      m_meshSkinEdgeSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    }

    m_meshSkinSwitch = new SoSwitch();
    {
      m_meshSkinSwitch.addChild(m_coloredMeshSkinSwitch);
      m_meshSkinSwitch.addChild(m_meshSkinEdgeSwitch);
      m_meshSkinSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    }

    m_meshSkinSep = new SoSeparator();
    {
      m_meshSkinSep.addChild(m_pickSwitch);
      m_meshSkinSep.addChild(m_meshSkinSwitch);
    }

    m_panel = new MeshSkinPanel(this);
    m_inventorNodes = new SoNode[]{m_meshSkin, mesh_skin_edge};
  }

  public String toString() {
    return m_name;
  }

  public RepresentNodePanel getPanel() {
    return m_panel;
  }

  public SoNode[] addToParent(DataNode parent, boolean is_drop_action) {
    m_parent = parent;
    if (m_parent instanceof Mesh3DNode)
      ((Mesh3DNode)m_parent).addMeshSkin(this);
    else
      ((Scalar3DNode)m_parent).addMeshSkin(this);

    if (! is_drop_action) {
      m_skinVector.add(this);
    }

    return m_inventorNodes;
  }

  public SoNode[] delete(boolean is_drop_action) {
    if (m_parent instanceof Mesh3DNode)
      ((Mesh3DNode)m_parent).removeMeshSkin(this);
    else
      ((Scalar3DNode)m_parent).removeMeshSkin(this);

    if (!is_drop_action) {
      for (int i = m_number; i < m_skinVector.size(); i++)
        ( (MeshSkinNode) m_skinVector.get(i)).decreaseNumber();
      m_skinVector.remove(m_number - 1);
    }

    return m_inventorNodes;
  }

  public void show(boolean show) {
    if (show)
      m_meshSkinSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
    else
      m_meshSkinSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
  }

  public DataNode getDataNodeParent() {
    return m_parent;
  }

  public void decreaseNumber() {
    m_number--;
    m_name = "Mesh Skin " + m_number;
    m_panel.changeTitleName(m_name);
  }

  public void setTransparency(float value) {
    m_transparencyValue = value;
    SoMaterial material =
        (SoMaterial)m_meshSkin.getPart("appearance.material", true);
    for (int i = 0; i < material.diffuseColor.getNum(); i++)
      material.transparency.set1Value(i, value);
  }

  class TransparencyCB extends PoRebuildCB {
    public void invoke(PoBase base) {
      setTransparency(m_transparencyValue);
    }
  }
}
