package meshviz.mesh.advanced.meshViewer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SpringLayout;

import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

public class MeshSkinPanel extends RepresentNodePanel {
  private final String[] SKIN_BOX_ITEMS = {
      "Mesh Skin", "Mesh Skin Edge", "Both"
  };
  private MeshSkinNode m_node;

  JComboBox<String> m_meshSkinBox;

  public MeshSkinPanel(MeshSkinNode node) {
    super(node, node.toString(), true, true);
    m_node = node;

    try {
      File help_file = new File(MeshViewer.m_filePrefix + "data/MeshSkinHelp.htm");
      m_helpPage = help_file.toURI().toURL();

      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jbInit() throws Exception {
    m_visibilityButton.setToolTipText("Mesh Skin visibility");

    m_transparencySlider.addSliderPanelListener(new SliderPanel.Listener() {
      public void stateChanged(float value) {
        m_node.setTransparency(value);
      }
    });

    m_coloringModeBox.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        int selected_index = m_coloringModeBox.getSelectedIndex();
        m_node.m_meshSkin.coloringType.setValue(selected_index);
        m_node.m_whichColoringType = selected_index;
      }
    });
    m_coloringModeBox.setSelectedIndex(2);

    m_meshSkinBox = new JComboBox<String>(SKIN_BOX_ITEMS);
    m_meshSkinBox.setSelectedIndex(0);
    m_meshSkinBox.addActionListener(new MeshSkinListener());
    JLabel mesh_skin_label = new JLabel("Mesh Skin");

    add(mesh_skin_label);
    add(m_meshSkinBox);
    m_spLayout.putConstraint(SpringLayout.WEST, mesh_skin_label, 10,
                             SpringLayout.WEST, this);
    m_spLayout.putConstraint(SpringLayout.NORTH, mesh_skin_label, 33,
                             SpringLayout.SOUTH, m_coloringModeBox);
    m_spLayout.putConstraint(SpringLayout.NORTH, m_meshSkinBox, 30,
                             SpringLayout.SOUTH, m_coloringModeBox);
    m_spLayout.putConstraint(SpringLayout.WEST, m_meshSkinBox, 35,
                             SpringLayout.EAST, mesh_skin_label);
    m_spLayout.putConstraint(SpringLayout.SOUTH, this, SOUTH_CONSTRAINT,
                             SpringLayout.SOUTH, m_meshSkinBox);
  }

  class MeshSkinListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      int selected_index = m_meshSkinBox.getSelectedIndex();
      switch (selected_index) {
        case 0:
          m_node.m_coloredMeshSkinSwitch.whichChild.setValue(SoSwitch.
              SO_SWITCH_ALL);
          m_node.m_meshSkinEdgeSwitch.whichChild.setValue(SoSwitch.
              SO_SWITCH_NONE);
          break;
        case 1:
          m_node.m_coloredMeshSkinSwitch.whichChild.setValue(SoSwitch.
              SO_SWITCH_NONE);
          m_node.m_meshSkinEdgeSwitch.whichChild.setValue(SoSwitch.
              SO_SWITCH_ALL);
          break;
        case 2:
          m_node.m_coloredMeshSkinSwitch.whichChild.setValue(SoSwitch.
              SO_SWITCH_ALL);
          m_node.m_meshSkinEdgeSwitch.whichChild.setValue(SoSwitch.
              SO_SWITCH_ALL);
          break;
      }
    }
  }
}
