package meshviz.mesh.advanced.meshViewer;

import javax.swing.tree.*;
import com.openinventor.inventor.nodes.*;

abstract class RepresentNode extends DefaultMutableTreeNode {

  protected SoSwitch m_pickSwitch;

  public RepresentNode() {
    // Pick style
    SoPickStyle pick_style = new SoPickStyle();
    pick_style.style.setValue(SoPickStyle.Styles.UNPICKABLE);
    m_pickSwitch = new SoSwitch();
    m_pickSwitch.addChild(pick_style);
    m_pickSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
  }

  public void setPickable(boolean pickable) {
    if (pickable)
      m_pickSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
    else
      m_pickSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
  }

  public abstract RepresentNodePanel getPanel();

  // add representation in scene graph
  public abstract SoNode[] addToParent(DataNode parent, boolean is_drop_action);

  // delete representation in scene graph
  public abstract SoNode[] delete(boolean is_drop_action);

  // hide or show representation
  public abstract void show(boolean show);

  public abstract DataNode getDataNodeParent();

}
