package meshviz.mesh.advanced.meshViewer;

import com.openinventor.inventor.nodes.*;
import com.openinventor.meshviz.data.*;

public class Scalar2DNode extends ScalarNode {
  private MeshViewer m_meshViewer;

  public Scalar2DNode(MeshViewer mesh_viewer, String name, int which_dataset) {
    m_name = name;
    m_whichDataset = which_dataset;
    m_meshViewer = mesh_viewer;

    m_dataGroup = (SoGroup)mesh_viewer.m_dataSwitch.getChild(which_dataset).copy();

    {
      m_scalarSep = new SoSeparator();
      m_scalarSep.addChild(new SoPolygonOffset());
      m_scalarSep.addChild(m_dataGroup);
      if (mesh_viewer.m_domain != null)
        m_scalarSep.addChild(mesh_viewer.m_domain);
    }

    m_meshViewer.m_scene3D.addChild(m_scalarSep);
  }

  // Mesh contouring
  public void addMeshContouring(MeshContouringNode mc_node) {
    mc_node.m_isoValuesSwitch.whichChild.setValue(m_whichDataset);
    mc_node.m_meshContouring.valuesIndex.setValue(m_whichDataset);
    m_scalarSep.addChild(mc_node.m_meshContouringSwitch);
  }

  public void removeMeshContouring(MeshContouringNode mc_node) {
    m_scalarSep.removeChild(mc_node.m_meshContouringSwitch);
  }

  // Mesh lines
  public void addMeshLines(MeshLinesNode ml_node) {
    ml_node.m_meshLines.valuesIndex.setValue(m_whichDataset);
    ml_node.m_meshLines.coloringType.setValue(PoMesh.ColoringTypes.COLOR_MAPPING);
    m_scalarSep.addChild(ml_node.m_meshLinesSwitch);
  }

  public void removeMeshLines(MeshLinesNode ml_node) {
    m_scalarSep.removeChild(ml_node.m_meshLinesSwitch);
  }

  // Mesh filled
  public void addMeshFilled(MeshFilledNode mf_node) {
    mf_node.m_meshFilled.valuesIndex.setValue(m_whichDataset);
    mf_node.m_meshFilled.coloringType.setValue(mf_node.m_whichColoringType);
    m_scalarSep.addChild(mf_node.m_meshFilledSwitch);
  }

  public void removeMeshFilled(MeshFilledNode mf_node) {
    m_scalarSep.removeChild(mf_node.m_meshFilledSwitch);
  }
}
