package meshviz.mesh.advanced.meshViewer;

import com.openinventor.inventor.nodes.*;
import com.openinventor.meshviz.data.*;

public class ScalarNode extends DataNode {
   protected int m_whichDataset;
   protected String m_name;
   protected SoSeparator m_scalarSep;
   protected SoGroup m_dataGroup;

   public String toString() {
     return m_name + " (scalar)";
   }

   public int getWhichDataset() {
     return m_whichDataset;
   }

   // Probe
   public void addMeshProbe(MeshProbeNode mp_node) {
     mp_node.m_cellFacets.valuesIndex.setValue(m_whichDataset);
     mp_node.m_cellFacets.coloringType.setValue(PoMesh.ColoringTypes.COLOR_MAPPING);
     mp_node.m_meshProbePoint.valuesIndex.setValue(m_whichDataset);
     m_scalarSep.addChild(mp_node.m_meshProbeSep);
   }

   public void removeMeshProbe(MeshProbeNode mp_node) {
     m_scalarSep.removeChild(mp_node.m_meshProbeSep);
   }
}
