package meshviz.mesh.advanced.meshViewer;

import com.openinventor.inventor.nodes.*;
import com.openinventor.meshviz.data.*;

public class Vector2DNode extends VectorNode {

  public Vector2DNode(MeshViewer mesh_viewer, String name, int which_dataset) {
    m_name = name;
    m_whichDataset = which_dataset;

    m_moduleDataMapping = mesh_viewer.m_moduleDataMapping;

    m_vectorSep = new SoSeparator();
    m_vectorSep.addChild(m_moduleDataMapping);

    mesh_viewer.m_scene3D.addChild(m_vectorSep);
  }

  // 2D Vector field
  public void addVecField(Mesh2DVecFieldNode vf_node) {
    vf_node.m_mesh2DVecField.vecsIndex.setValue(m_whichDataset);
    vf_node.m_mesh2DVecField.bodyColoringType.setValue(PoMesh2DVec.ArrowColoringTypes.MODULE_MAPPING_COLOR);
    m_vectorSep.addChild(vf_node.m_mesh2DVecFieldSwitch);
  }

  public void removeVecField(Mesh2DVecFieldNode vf_node) {
    m_vectorSep.removeChild(vf_node.m_mesh2DVecFieldSwitch);
  }
}
