package meshviz.mesh.advanced.meshViewer;

import com.openinventor.meshviz.data.*;
import com.openinventor.inventor.nodes.*;
import com.openinventor.meshviz.nodes.*;

public class VectorNode extends DataNode {
  protected int m_whichDataset;
  protected String m_name;
  protected SoSeparator m_vectorSep;
  protected PoNonLinearDataMapping2 m_moduleDataMapping;

  public int getWhichDataset() {
    return m_whichDataset;
  }

  public String toString() {
    return m_name + " (vector)";
  }

  // Stream
  public void addStream(MeshStreamNode ms_node) {
    ms_node.m_meshStreamLines.vecsIndex.setValue(m_whichDataset);
    ms_node.m_meshStreamLineParticle.coloringType.setValue(PoMesh.ColoringTypes.COLOR_MAPPING);
    ms_node.m_meshStreamLines.coloringType.setValue(PoMesh.ColoringTypes.COLOR_MAPPING);
    ms_node.m_meshStreamPoint.coloringType.setValue(PoMesh.ColoringTypes.COLOR_MAPPING);
    ms_node.m_meshStreamSphere.coloringType.setValue(PoMesh.ColoringTypes.COLOR_MAPPING);
    ms_node.m_meshStreamSurface.coloringType.setValue(PoMesh.ColoringTypes.COLOR_MAPPING);
    ms_node.m_meshStreamTadpole.coloringType.setValue(PoMesh.ColoringTypes.COLOR_MAPPING);
    m_vectorSep.addChild(ms_node.m_meshStreamSep);
  }

  public void removeStream(MeshStreamNode ms_node) {
    m_vectorSep.removeChild(ms_node.m_meshStreamSep);
  }
}
