// MeshExample : mesh representation with legend (carpet plot)
package meshviz.mesh.mentor.meshExample;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.nodes.SoGroup;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.data.PoMesh;
import com.openinventor.meshviz.data.PoMeshFilled;
import com.openinventor.meshviz.graph.PoNonLinearValueLegend1;
import com.openinventor.meshviz.nodes.PoIsovaluesList;
import com.openinventor.meshviz.nodes.PoNonLinearDataMapping2;
import com.openinventor.meshviz.nodes.PoParalCartesianGrid2D;
import com.openinventor.util.AsciiStreamReader;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private float vmin, vmax;
  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Mesh Example");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    String oivjhome = SoPreferences.getValue("OIVJHOME");
    PoParalCartesianGrid2D mesh = readFiles(oivjhome + "/data/mesh/mesh2d.geo",
        oivjhome + "/data/mesh/mesh2d.dat");
    if (mesh == null) return;

    // Define data mapping
    SbColor[] colors = {new SbColor(0,0,1), new SbColor(0,1,1), new SbColor(0,1,0),
			new SbColor(1,1,0), new SbColor(1,0,0)} ;
    float[] values = new float[5];
    values[0] = vmin; for (int j=1; j<5; j++) values[j] = values[j-1] + (vmax-vmin)/4;
    PoNonLinearDataMapping2 myDataMapping = new PoNonLinearDataMapping2();
    myDataMapping.type.setValue(PoNonLinearDataMapping2.Types.LINEAR_PER_LEVEL);
    myDataMapping.color.setValues(0,colors);
    myDataMapping.value.setValues(0,values);

    // Define the list of iso-values
    PoIsovaluesList myIsovaluesList = new PoIsovaluesList() ;
    myIsovaluesList.setRegularIsoList(vmin, vmax, 16);

    // Create the legend node
    PoNonLinearValueLegend1 myLegend =
      new PoNonLinearValueLegend1(new SbVec2f(-1, 1), new SbVec2f(-0.5F, -0.5F)) ;
    myLegend.set("backgroundApp.material", "diffuseColor .4 .4 .4") ;

    SoAnnotation legendAnnot =  new SoAnnotation();
    legendAnnot.addChild(myLegend) ;

    // Create the solid contour visualization node.
    PoMeshFilled myFill = new PoMeshFilled();
    myFill.valuesIndex.setValue((short)0);
    myFill.zValuesIndex.setValue((short)0);
    myFill.coloringType.setValue(PoMesh.ColoringTypes.COLOR_CONTOURING);

    SbColor bkgColor = new SbColor(Color.WHITE);
    SoGradientBackground background = new SoGradientBackground();
    background.color0.setValue(bkgColor);
    background.color1.setValue(bkgColor);

    // Create the root of the scene graph
    SoGroup root = new SoGroup();
    { // assemble scene graph
      root.addChild(background);
      root.addChild(myDataMapping);
      root.addChild(mesh);
      root.addChild(myIsovaluesList);
      root.addChild(legendAnnot);
    }
    myViewer.getRenderArea().getSceneInteractor().insertChild(root, 0);

    myViewer.setSceneGraph(myFill) ;
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  private synchronized PoParalCartesianGrid2D readFiles(String topoFile, String dataFile) {
    float[] x,y,val;
    int numX, numY;
    PoParalCartesianGrid2D mesh = null;

    URL url_topo = getURL(topoFile);
    if (url_topo == null) return null;

    URL url_data = getURL(dataFile);
    if (url_data == null) return null;

    AsciiStreamReader stream = null;
    try {
      int i, num_val ;
      stream = new AsciiStreamReader(url_topo.openStream()) ;

      numX = stream.readNextInt ();
      numY = stream.readNextInt ();
      System.out.println("Reading " + numX + " * " + numY + " nodes");

      x = new float[numX];
      y = new float[numY];

      for (i=0 ; i<numX ; i++) x[i] = stream.readNextFloat();
      for (i=0 ; i<numY ; i++) y[i] = stream.readNextFloat();

      System.out.println("End reading mesh geometry.") ;

      stream = new AsciiStreamReader(url_data.openStream());

      num_val = numX * numY;
      val = new float[num_val] ;

      vmin = 1.E30F;
      vmax = -1.E30F;

      for(i=0 ; i< num_val ; i++) {
        val[i] = stream.readNextFloat ();
        if (val[i] < vmin) vmin = val[i] ;
        if (val[i] > vmax) vmax = val[i] ;
      }
      System.out.println("End reading mesh values.") ;

      // Initialize the mesh
      mesh = new PoParalCartesianGrid2D();
      mesh.setGeometry(numX, numY, x,y);
      mesh.addValuesSet(0, val);

    }
    catch (java.io.IOException ex) {
      System.err.println(ex + "on file " + topoFile + "or " + dataFile);
    }

    return mesh;

  }

  private URL getURL(String fileName) {
    URL url = null;
    try {
      url = new URL("file:"+(new File(fileName)).getAbsolutePath()) ;
    }
    catch (MalformedURLException exc) {
      System.err.println(exc + " : (" + url + ") " + fileName + " invalid URL");
      url = null;
    }
    catch (Exception e) {
      System.err.println(e + " : cant load File "+ fileName);
      url = null;
    }
    return url;
  }
}
