package meshviz.mesh.sample;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.JPanel;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.data.PbMesh;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoIsovaluesList;
import com.openinventor.meshviz.nodes.PoMeshProperty;
import com.openinventor.meshviz.nodes.PoNonLinearDataMapping2;

import meshviz.mesh.sample.dialog.PoAwtDialog;
import util.ViewerComponentsFactory;

/**
  * @author Rodolphe Albout
  * @author Loic Vigneras
  * @author Patrick Vigneras
  */
public class MeshViewer extends JPanel {
  private SoSeparator m_View3D;

  protected static boolean DEBUG = false;

  // Constants
  // ---------

  protected static final String[] colrtList = {
    "constant",
    "average",
    "mapping",
    "contouring"
  };
  protected static final String[] stream_rep = {
    "none",
    "line",
    "line & particle",
    "tadpole",
    "point",
    "sphere",
    "surface"
  };
  protected static final String[] transType = {
    "No sort",
    "Opaque first",
    "Sorted object",
    "Sorted pixel"
  };
  protected static final String[] vecType = {
    "lines",
    "cylinder & cone"
  };
  protected static final String[] planeOrient = {
    "X",
    "Y",
    "Z"
  };

  // Constructor
  // -----------

  public MeshViewer () {
    super ();
    v_DataSetNames = new String[0];
    v_DataSetIndex = 0;
    v_Domain = null;
    v_NumIsoValues = 16;
    v_VecFieldDensity = 1;
    v_VecLengthFactor = 1.0f;
    v_WindowTitle = "mesh_viewer";
    v_CourtesyTitle = " ";
  }

  // Methods
  // -------

  public void destroy()
  {
    v_Viewer.dispose();
  }

  public void setDataSetNames (String[] names) {
    v_DataSetNames = new String[names.length + 1];
    v_DataSetNames[0] = "no data";
    System.arraycopy (names, 0, v_DataSetNames, 1, names.length);
  }

  //--------------------------------------------------------------------------------------------
  public void setWindowTitle (String windowTitle) {
    v_WindowTitle = windowTitle;
  }

  //--------------------------------------------------------------------------------------------
  public void setCourtesyTitle (String courtesyTitle) {
    v_CourtesyTitle = courtesyTitle;
  }

  //--------------------------------------------------------------------------------------------
  public void setDataSetIndex (int index) {
    v_DataSetIndex = index;
  }

  //--------------------------------------------------------------------------------------------
  public void setNumIsoValues (int numIso) {
    if (numIso > 0)
      v_NumIsoValues = numIso;
  }

  //--------------------------------------------------------------------------------------------
  public void setVecFieldDensity (int density) {
    v_VecFieldDensity = density;
  }

  //--------------------------------------------------------------------------------------------
  public void setVecLengthFactor (float lengthFactor) {
    v_VecLengthFactor = lengthFactor;
  }

  //--------------------------------------------------------------------------------------------
  protected void initShow (PoMeshProperty po_mesh) {

    if (DEBUG) System.out.println ("DEBUG: MeshViewer.initShow(): Create colors");
    SbColor[] colors = {
      new SbColor (0,0,1),
      new SbColor (0,1,1),
      new SbColor (0,1,0),
      new SbColor (1,1,0),
      new SbColor (1,0,0)
    };

    PbMesh mesh = po_mesh.getMesh();
    v_DataSetNum = mesh.getNumValuesSet ();
    v_Vmin = new float[v_DataSetNum];
    v_Vmax = new float[v_DataSetNum];
    v_DataMapping = new PoNonLinearDataMapping2[v_DataSetNum];
    v_IsoValues = new PoIsovaluesList[v_DataSetNum];

    // alloc the data names if necessary
    if (v_DataSetNames.length == 0) {
      v_DataSetNames = new String[v_DataSetNum];
      for (int i = 0; i < v_DataSetNum; i++)
	v_DataSetNames[i] = ("Data set " + i);
    }

    // define the data-mapping and the iso-value list associated to each set
    // of data-set
    float[] val = new float[5];
    float dv;
    int j;
    for (int i = 0; i < v_DataSetNum; i++) {
      v_Vmin[i] = mesh.getMinValuesSet(i);
      v_Vmax[i] = mesh.getMaxValuesSet(i) ;
      dv = (v_Vmax[i] - v_Vmin[i]) / 4;
      val[0] = v_Vmin[i];
      for (j = 1; j < 5; j++)
	val[j] = val[j-1] + dv;
      v_DataMapping[i] = new PoNonLinearDataMapping2 ();
      v_DataMapping[i].type.setValue(PoNonLinearDataMapping2.Types.LINEAR_PER_LEVEL);
      v_DataMapping[i].color.setValues(0,colors);
      v_DataMapping[i].value.setValues(0,val);

      // define the list of iso-value associated to the i-th data-set
      v_IsoValues[i] = new PoIsovaluesList();
      v_IsoValues[i].setRegularIsoList(v_Vmin[i],v_Vmax[i],v_NumIsoValues);
    }

    // define the data-mapping associated to the module of vectors
    float vmin = mesh.getMinVecsSet(0);
    float vmax = mesh.getMaxVecsSet(0);
    dv = (vmax - vmin) / 4;
    val[0] = vmin ;
    for (j = 1; j < 5; j++)
      val[j] = val[j-1] + dv;
    v_ModuleDataMapping = new PoNonLinearDataMapping2 ();
    v_ModuleDataMapping.type.setValue(PoNonLinearDataMapping2.Types.LINEAR_PER_LEVEL);
    v_ModuleDataMapping.color.setValues(0,colors);
    v_ModuleDataMapping.value.setValues(0,val);
  }

  protected void startShow () {
    /*
    // build courtesy title
    SoFont font = new SoFont ();
    font.size.setValue (12);
    SoTranslation courtesyTrans = new SoTranslation ();
    courtesyTrans.translation.setValue (0.95f, -0.95f, -1);
    SoText2 courtesyTitle = new SoText2 ();
    courtesyTitle.string.setValue (v_CourtesyTitle);
    courtesyTitle.justification.setValue (SoText2.RIGHT);

    // build colored legend
    v_DataLegend = myLegend ("Courier New");
    v_DataLegendSwitch = new SoSwitch ();
    v_DataLegendSwitch.addChild (v_DataLegend) ;
    v_DataLegendSwitch.whichChild = SO_SWITCH_ALL;

    // pick style node
    SoPickStyle pickStyle = new SoPickStyle ();
    pickStyle.style.setValue (SoPickStyle.UNPICKABLE);

    v_Scene2D = new SoAnnotation ();
    v_Scene2D.addChild (pickStyle);
    v_Scene2D.addChild (v_DataLegendSwitch);
    v_Scene2D.addChild (font);
    v_Scene2D.addChild (courtesyTrans);
    v_Scene2D.addChild (courtesyTitle);
    */

    v_Viewer = ViewerComponentsFactory.createViewerExaminer();

    v_Root = new SoSeparator ();

    m_View3D = new SoSeparator();
    m_View3D.addChild (v_Scene3D);
    v_Root.addChild (m_View3D);

    //  SoSeparator m_View2D = new SoSeparator();
    //  m_View2D.addChild (camera2D);
    //  m_View2D.addChild (DemoInventor.graphicBackground());
    //  v_Root.addChild (m_View2D);

    v_Viewer.setSceneGraph (v_Root);
    v_Viewer.getComponent().setName (v_WindowTitle);
    v_Viewer.viewAll();

    v_Dialog.setVisible (true);

    linkInnerComponents ();
  }

  //--------------------------------------------------------------------------------------------
  // Layout and link inner components to the panel of this element
  private void linkInnerComponents () {
    /*
    GridBagLayout gridbag = new GridBagLayout ();
    GridBagConstraints c = new GridBagConstraints ();
    //    c.insets = new Insets (0, MARGIN_OFFSET, 0, 0);
    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1.0;
    c.weighty = 1.0;
    gridbag.setConstraints (v_Dialog, c);
    gridbag.setConstraints (v_Viewer, c);
    */
    //    this.setLayout (gridbag);

    final Component component = v_Viewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));

    setLayout(new BorderLayout()) ;
    this.add ("West",v_Dialog);
    this.add ("Center",component);
  }

  public static URL getURL(String fileName) {
    URL url = null;
    try {
      url = new URL("file:"+(new File(fileName)).getAbsolutePath()) ;
    }
    catch (MalformedURLException exc) {
      System.err.println(exc + " : (" + url + ") " + fileName + " invalid URL");
      url = null;
    }
    catch (Exception e) {
      System.err.println(e + " : cant load File "+ fileName);
      url = null;
    }
    return url;
  }

  // Fields
  // ------
  static String Scene3DName = "Scene3D";

  protected PoAwtDialog v_Dialog;
//  protected PoNonLinearValueLegend3 v_DataLegend;

//  protected SoSwitch v_DataLegendSwitch;
  protected SoSeparator v_Root;
  protected SoSeparator v_Scene3D;
  protected SoAnnotation v_Scene2D;
  protected IViewerExaminer v_Viewer;

  protected int v_DataSetNum;
  protected int v_DataSetIndex;
  protected float[] v_Vmin, v_Vmax;
  protected float v_ScaleFactor;

  protected String[] v_DataSetNames;
  protected String v_WindowTitle;
  protected String v_CourtesyTitle;
  protected float v_VecFieldWidth;
  protected int v_NumIsoValues;
  protected int v_VecFieldDensity;
  protected float v_VecLengthFactor;

  protected PoDomain v_Domain;
  protected PoIsovaluesList[] v_IsoValues;
  protected PoNonLinearDataMapping2[] v_DataMapping;
  protected PoNonLinearDataMapping2 v_ModuleDataMapping;
}
