package meshviz.mesh.sample;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JPanel;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.actions.SoWriteAction;
import com.openinventor.inventor.nodes.SoEnvironment;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;
import com.openinventor.meshviz.data.PbMesh;
import com.openinventor.meshviz.data.PoMesh;
import com.openinventor.meshviz.data.PoMesh2DVec;
import com.openinventor.meshviz.data.PoMeshLines;
import com.openinventor.meshviz.nodes.PoDomain;
import com.openinventor.meshviz.nodes.PoMeshProperty;
import com.openinventor.meshviz.nodes.PoNonLinearDataMapping2;

import util.ViewerComponentsFactory;

/**
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  */
public class Vec2DViewer extends JPanel {
  static final int TRIGGER_IV_FILE = 0 ;
  static final int TOGGLE_LINES = 1 ;
  static final int TOGGLE_VEC_FIELD = 2 ;

  static final int SLIDER_DENSITY = 3 ;
  static final int CHOICE_ELIMINATE = 4 ;
  static final int SLIDER_MIN_LEN = 5 ;
  static final int SLIDER_MAX_LEN = 6 ;

  static final int BODY_LABEL = 7 ;
  static final int CHOICE_BODY_SHAPE = 8 ;
  static final int CHOICE_BODY_LEN_TYPE = 9 ;
  static final int SLIDER_BODY_LEN_FACTOR = 10 ;
  static final int CHOICE_BODY_RADIUS_TYPE = 11 ;
  static final int SLIDER_BODY_RADIUS_FACTOR = 12 ;
  static final int CHOICE_BODY_COLORING_TYPE = 13 ;

  static final int START_ARROW_LABEL = 14 ;
  static final int CHOICE_START_ARROW_SHAPE = 15 ;
  static final int CHOICE_START_ARROW_HEIGHT_TYPE = 16 ;
  static final int SLIDER_START_ARROW_HEIGHT_FACTOR = 17 ;
  static final int SLIDER_START_ARROW_RADIUS_FACTOR = 18 ;
  static final int CHOICE_START_ARROW_COLORING_TYPE = 19 ;

  static final int END_ARROW_LABEL = 20 ;
  static final int CHOICE_END_ARROW_SHAPE = 21 ;
  static final int CHOICE_END_ARROW_HEIGHT_TYPE = 22 ;
  static final int SLIDER_END_ARROW_HEIGHT_FACTOR = 23 ;
  static final int SLIDER_END_ARROW_RADIUS_FACTOR = 24 ;
  static final int CHOICE_END_ARROW_COLORING_TYPE = 25 ;

  static final int NUM_DIALOG_ELEM = 26 ;

  private Panel dialog ;

  private PoMeshLines v_MeshLines ;
  private PoMesh2DVec v_MeshVecField ;

  private SoSwitch v_MeshLinesSwitch ;
  private SoSwitch v_MeshVecFieldSwitch ;

  private SoSeparator v_Root ;
  private IViewerExaminer v_Viewer ;

  private PoDomain v_Domain ;
  private String fileName ;
  private Button buttonIvFile ;

  public Vec2DViewer() {
    super(new BorderLayout()) ;
    dialog = new Panel() ;
    fileName = new String("2D_mesh_viewer") ;
    buildDialogBox(dialog) ;
    v_Viewer = ViewerComponentsFactory.createViewerExaminer();
    add(dialog, BorderLayout.WEST);
    add(v_Viewer.getComponent(), BorderLayout.CENTER);
  }
  public IViewerExaminer getViewer() {
     return v_Viewer;
  }

  public void setFileName(String name) {
    if (name != null) {
      fileName = name ;
      if (buttonIvFile != null)
	buttonIvFile.setLabel(name + " file") ;
    }
  }

  public void show(PoMeshProperty po_mesh) {
    SbColor[] colors = { new SbColor(0,0,1), new SbColor(0,1,1), new SbColor(0,1,0),
			 new SbColor(1,1,0), new SbColor(1,0,0)} ;
    float[] val = new float[5] ;
    float dv, vmin, vmax ;
    int j ;

    PbMesh mesh = po_mesh.getMesh();

    // define the data-mapping associated to the scalar-data at mesh-nodes
    vmin = mesh.getMinValuesSet(0);
    vmax = mesh.getMaxValuesSet(0);
    dv = (vmax-vmin)/4;
    val[0] = vmin; for (j=1; j<5; j++) val[j] = val[j-1]+dv;

    PoNonLinearDataMapping2 v_ScalarDataMapping = new PoNonLinearDataMapping2() ;
    v_ScalarDataMapping.type.setValue(PoNonLinearDataMapping2.Types.LINEAR_PER_LEVEL);
    v_ScalarDataMapping.color.setValues(0,colors);
    v_ScalarDataMapping.value.setValues(0,val);

   // define the data-mapping associated to the scalar-data at mesh-nodes
    vmin = mesh.getMinVecsSet(0);
    vmax = mesh.getMaxVecsSet(0);
    dv = (vmax-vmin)/4;
    val[0] = vmin; for (j=1; j<5; j++) val[j] = val[j-1]+dv;

    PoNonLinearDataMapping2 v_ModuleDataMapping = new PoNonLinearDataMapping2() ;
    v_ModuleDataMapping.type.setValue(PoNonLinearDataMapping2.Types.LINEAR_PER_LEVEL);
    v_ModuleDataMapping.color.setValues(0,colors);
    v_ModuleDataMapping.value.setValues(0,val);

    v_MeshLines = new PoMeshLines();
    v_MeshLines.valuesIndex.setValue(0);
    v_MeshLines.zValuesIndex.setValue((short) 1);
    v_MeshLines.coloringType.setValue(PoMesh.ColoringTypes.COLOR_MAPPING);

    v_MeshVecField = new PoMesh2DVec();
    v_MeshVecField.vecsIndex.setValue(0);
    v_MeshVecField.valuesIndex.setValue(0);
    v_MeshVecField.zValuesIndex.setValue((short) 1);
    //    v_MeshVecField.setModuleDataMapping(v_ModuleDataMapping);

    v_MeshLinesSwitch = new SoSwitch();
    v_MeshLinesSwitch.addChild(v_MeshLines) ;
    v_MeshLinesSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);

    v_MeshVecFieldSwitch = new SoSwitch();
    v_MeshVecFieldSwitch.addChild(v_MeshVecField) ;
    v_MeshVecFieldSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);

    SoEnvironment myEnvironment = new SoEnvironment();
    myEnvironment.ambientColor.setValue(1,1,1);
    myEnvironment.ambientIntensity.setValue(0.8F);

    v_Root = new SoSeparator() ;
    v_Root.addChild(myEnvironment);
    if (v_Domain != null) v_Root.addChild(v_Domain);
    v_Root.addChild(po_mesh);
    v_Root.addChild(v_ScalarDataMapping);
    v_Root.addChild(v_MeshLinesSwitch);
    v_Root.addChild(v_MeshVecFieldSwitch);

    v_Viewer.setSceneGraph(v_Root);

    dialog.setVisible(true) ;
  }

  private void buildDialogBox(Panel dialog) {
    Panel left, right ;
    left = new Panel(new GridLayout(26,1)) ;
    right = new Panel(new GridLayout(26,1)) ;

    Label labelIvFile = new Label("write") ;
    buttonIvFile = new Button(fileName + " file") ;
    buttonIvFile.addActionListener(new ListenButton()) ;

    Label labelElimination = new Label("Elimination");
    Choice choiceElimination = new Choice() ;
    choiceElimination.add("none") ;
    choiceElimination.add("too small") ;
    choiceElimination.add("too long") ;
    choiceElimination.add("too small or too long") ;
    choiceElimination.select(0) ;
    choiceElimination.addItemListener(new ListenChoice(CHOICE_ELIMINATE)) ;

    Label labelBodyShape = new Label("type") ;
    Choice choiceBodyShape = new Choice() ;
    choiceBodyShape.add("no body") ;
    choiceBodyShape.add("line") ;
    choiceBodyShape.add("cylinder") ;
    choiceBodyShape.select(1) ;
    choiceBodyShape.addItemListener(new ListenChoice(CHOICE_BODY_SHAPE)) ;

    Label labelBodyLenType = new Label("length type") ;
    Choice choiceBodyLenType = new Choice() ;
    choiceBodyLenType.add("constant length") ;
    choiceBodyLenType.add("relative length") ;
    choiceBodyLenType.select(1) ;
    choiceBodyLenType.addItemListener(new ListenChoice(CHOICE_BODY_LEN_TYPE)) ;

    Label labelBodyRadiusType = new Label("radius type") ;
    Choice choiceBodyRadiusType = new Choice() ;
    choiceBodyRadiusType.add("constant radius") ;
    choiceBodyRadiusType.add("relative radius") ;
    choiceBodyRadiusType.select(1) ;
    choiceBodyRadiusType.addItemListener(new ListenChoice(CHOICE_BODY_RADIUS_TYPE)) ;

    Label labelBodyColoringType = new Label("color") ;
    Choice choiceBodyColoringType = new Choice() ;
    choiceBodyColoringType.add("constant") ;
    choiceBodyColoringType.add("module mapping") ;
    choiceBodyColoringType.add("scalar mapping") ;
    choiceBodyColoringType.select(0) ;
    choiceBodyColoringType.addItemListener(new ListenChoice(CHOICE_BODY_COLORING_TYPE)) ;

    Label labelStartArrowShape = new Label("type") ;
    Choice choiceStartArrowShape = new Choice() ;
    choiceStartArrowShape.add("no shape") ;
    choiceStartArrowShape.add("point") ;
    choiceStartArrowShape.add("chevron") ;
    choiceStartArrowShape.add("triangle") ;
    choiceStartArrowShape.add("rectangle") ;
    choiceStartArrowShape.add("cone") ;
    choiceStartArrowShape.add("box") ;
    choiceStartArrowShape.add("sphere") ;
    choiceStartArrowShape.add("indirect chevron") ;
    choiceStartArrowShape.add("indirect triangle") ;
    choiceStartArrowShape.add("indirect cone") ;
    choiceStartArrowShape.select(0) ;
    choiceStartArrowShape.addItemListener(new ListenChoice(CHOICE_START_ARROW_SHAPE)) ;

    Label labelStartArrowHeightType = new Label("height type") ;
    Choice choiceStartArrowHeightType = new Choice() ;
    choiceStartArrowHeightType.add("constant") ;
    choiceStartArrowHeightType.add("relative") ;
    choiceStartArrowHeightType.select(1) ;
    choiceStartArrowHeightType.addItemListener(new ListenChoice(CHOICE_START_ARROW_HEIGHT_TYPE)) ;

    Label labelStartArrowColoringType = new Label("color type") ;
    Choice choiceStartArrowColoringType = new Choice() ;
    choiceStartArrowColoringType.add("constant") ;
    choiceStartArrowColoringType.add("module mapping") ;
    choiceStartArrowColoringType.add("scalar mapping") ;
    choiceStartArrowColoringType.select(0) ;
    choiceStartArrowColoringType.addItemListener(new ListenChoice(CHOICE_START_ARROW_COLORING_TYPE)) ;

    Label labelEndArrowShape = new Label("type") ;
    Choice choiceEndArrowShape = new Choice() ;
    choiceEndArrowShape.add("no shape") ;
    choiceEndArrowShape.add("point") ;
    choiceEndArrowShape.add("chevron") ;
    choiceEndArrowShape.add("triangle") ;
    choiceEndArrowShape.add("rectangle") ;
    choiceEndArrowShape.add("cone") ;
    choiceEndArrowShape.add("box") ;
    choiceEndArrowShape.add("sphere") ;
    choiceEndArrowShape.add("indirect chevron") ;
    choiceEndArrowShape.add("indirect triangle") ;
    choiceEndArrowShape.add("indirect cone") ;
    choiceEndArrowShape.select(0) ;
    choiceEndArrowShape.addItemListener(new ListenChoice(CHOICE_END_ARROW_SHAPE)) ;

    Label labelEndArrowHeightType = new Label("height type") ;
    Choice choiceEndArrowHeightType = new Choice() ;
    choiceEndArrowHeightType.add("constant") ;
    choiceEndArrowHeightType.add("relative") ;
    choiceEndArrowHeightType.select(1) ;
    choiceEndArrowHeightType.addItemListener(new ListenChoice(CHOICE_END_ARROW_HEIGHT_TYPE)) ;

    Label labelEndArrowColoringType = new Label("color type") ;
    Choice choiceEndArrowColoringType = new Choice() ;
    choiceEndArrowColoringType.add("constant") ;
    choiceEndArrowColoringType.add("module mapping") ;
    choiceEndArrowColoringType.add("scalar mapping") ;
    choiceEndArrowColoringType.select(0) ;
    choiceEndArrowColoringType.addItemListener(new ListenChoice(CHOICE_END_ARROW_COLORING_TYPE)) ;

    Checkbox switchLines = new Checkbox("Mesh Lines", true) ;
    Checkbox switchVecField = new Checkbox("Vec Field", true) ;
    switchLines.addItemListener(new ListenCheckbox(TOGGLE_LINES)) ;
    switchVecField.addItemListener(new ListenCheckbox(TOGGLE_VEC_FIELD)) ;

    SliderPanel sliderDensity = new SliderPanel(1,10,1) ;
    sliderDensity.addSliderPanelListener(new ListenSlider(SLIDER_DENSITY)) ;
    Label labelDensity = new Label("Density") ;

    SliderPanel sliderMinLen = new SliderPanel(0,10,0) ;
    sliderMinLen.addSliderPanelListener(new ListenSlider(SLIDER_MIN_LEN)) ;
    Label labelMinLen = new Label("Min length") ;

    SliderPanel sliderMaxLen = new SliderPanel(0,10,10) ;
    sliderMaxLen.addSliderPanelListener(new ListenSlider(SLIDER_MAX_LEN)) ;
    Label labelMaxLen = new Label("Max length") ;

    SliderPanel sliderBodyLenFactor = new SliderPanel(0.5f, 3, 1, 2) ;
    sliderBodyLenFactor.addSliderPanelListener(new ListenSlider(SLIDER_BODY_LEN_FACTOR)) ;
    Label labelBodyLenFactor = new Label("length") ;

    SliderPanel sliderBodyRadiusFactor = new SliderPanel(0.01f, 0.05f, 0.02f, 2) ;
    sliderBodyRadiusFactor.addSliderPanelListener(new ListenSlider(SLIDER_BODY_RADIUS_FACTOR)) ;
    Label labelBodyRadiusFactor = new Label("radius") ;

    SliderPanel sliderStartArrowHeightFactor = new SliderPanel(0.05f, 0.3f, 0.1f, 2) ;
    sliderStartArrowHeightFactor.addSliderPanelListener(new ListenSlider(SLIDER_START_ARROW_HEIGHT_FACTOR)) ;
    Label labelStartArrowHeightFactor = new Label("height") ;

    SliderPanel sliderStartArrowRadiusFactor = new SliderPanel(0.1f, 1, 0.5f, 2) ;
    sliderStartArrowRadiusFactor.addSliderPanelListener(new ListenSlider(SLIDER_START_ARROW_RADIUS_FACTOR)) ;
    Label labelStartArrowRadiusFactor = new Label("radius") ;

    SliderPanel sliderEndArrowHeightFactor = new SliderPanel(0.05f, 0.3f, 0.1f, 2) ;
    sliderEndArrowHeightFactor.addSliderPanelListener(new ListenSlider(SLIDER_END_ARROW_HEIGHT_FACTOR)) ;
    Label labelEndArrowHeightFactor = new Label("height") ;

    SliderPanel sliderEndArrowRadiusFactor = new SliderPanel(0.1f, 1, 0.5f, 2) ;
    sliderEndArrowRadiusFactor.addSliderPanelListener(new ListenSlider(SLIDER_END_ARROW_RADIUS_FACTOR)) ;
    Label labelEndArrowRadiusFactor = new Label("radius") ;

    Font font = new Font("Courier New", Font.BOLD, 12) ;
    Label bodyLabel = new Label("Arrow bodies", Label.CENTER) ;
    Label startArrowLabel = new Label("Arrow heads", Label.CENTER) ;
    Label endArrowLabel = new Label("Arrow tails", Label.CENTER) ;
    bodyLabel.setFont(font) ;
    startArrowLabel.setFont(font) ;
    endArrowLabel.setFont(font) ;

    left.add(buttonIvFile) ; right.add(labelIvFile) ;
    left.add(switchLines) ; right.add(new Label()) ;
    left.add(switchVecField) ; right.add(new Label()) ;

    left.add(sliderDensity) ; right.add(labelDensity) ;
    left.add(choiceElimination) ; right.add(labelElimination) ;
    left.add(sliderMinLen) ; right.add(labelMinLen) ;
    left.add(sliderMaxLen) ; right.add(labelMaxLen) ;

    left.add(bodyLabel) ; right.add(new Label()) ;
    left.add(choiceBodyShape) ; right.add(labelBodyShape) ;
    left.add(choiceBodyLenType) ; right.add(labelBodyLenType) ;
    left.add(sliderBodyLenFactor) ; right.add(labelBodyLenFactor) ;
    left.add(choiceBodyRadiusType) ; right.add(labelBodyRadiusType) ;
    left.add(sliderBodyRadiusFactor) ; right.add(labelBodyRadiusFactor) ;
    left.add(choiceBodyColoringType) ; right.add(labelBodyColoringType) ;

    left.add(startArrowLabel) ; right.add(new Label()) ;
    left.add(choiceStartArrowShape) ; right.add(labelStartArrowShape) ;
    left.add(choiceStartArrowHeightType) ; right.add(labelStartArrowHeightType) ;
    left.add(sliderStartArrowHeightFactor) ; right.add(labelStartArrowHeightFactor) ;
    left.add(sliderStartArrowRadiusFactor) ; right.add(labelStartArrowRadiusFactor) ;
    left.add(choiceStartArrowColoringType) ; right.add(labelStartArrowColoringType) ;

    left.add(endArrowLabel) ; right.add(new Label()) ;
    left.add(choiceEndArrowShape) ; right.add(labelEndArrowShape) ;
    left.add(choiceEndArrowHeightType) ; right.add(labelEndArrowHeightType) ;
    left.add(sliderEndArrowHeightFactor) ; right.add(labelEndArrowHeightFactor) ;
    left.add(sliderEndArrowRadiusFactor) ; right.add(labelEndArrowRadiusFactor) ;
    left.add(choiceEndArrowColoringType) ; right.add(labelEndArrowColoringType) ;

    dialog.setLayout(new BorderLayout());
    dialog.add(right, BorderLayout.WEST);
    dialog.add(left, BorderLayout.EAST);
  }

  class ListenChoice implements ItemListener {
    int type ;
    public ListenChoice(int type) { this.type = type ; }
    public void itemStateChanged(ItemEvent e) {
      int choiceVal = ((Choice) e.getSource()).getSelectedIndex() ;
      switch(type) {
      case CHOICE_ELIMINATE :
	// change eliminate type
	switch (choiceVal) {
	case 0: v_MeshVecField.eliminationStatus.setValue(PoMesh2DVec.EliminationStatusType.NONE) ; break;
	case 1: v_MeshVecField.eliminationStatus.setValue(PoMesh2DVec.EliminationStatusType.TOO_SMALL) ; break;
	case 2: v_MeshVecField.eliminationStatus.setValue(PoMesh2DVec.EliminationStatusType.TOO_LONG) ; break;
	case 3: v_MeshVecField.eliminationStatus.setValue(PoMesh2DVec.EliminationStatusType.TOO_SMALL_OR_LONG) ; break;
	}
	break;

      case CHOICE_BODY_SHAPE :
	switch (choiceVal) {
	case 0: v_MeshVecField.bodyShape.setValue(PoMesh2DVec.BodyShapes.NO_BODY) ; break;
	case 1: v_MeshVecField.bodyShape.setValue(PoMesh2DVec.BodyShapes.LINE) ; break;
	case 2: v_MeshVecField.bodyShape.setValue(PoMesh2DVec.BodyShapes.CYLINDER) ; break;
	}
	break;
      case CHOICE_BODY_LEN_TYPE :
	switch (choiceVal) {
	case 0 : v_MeshVecField.bodyLengthType.setValue(PoMesh2DVec.BodyLengthTypes.CONSTANT_LENGTH) ; break;
	case 1 : v_MeshVecField.bodyLengthType.setValue(PoMesh2DVec.BodyLengthTypes.RELATIVE_LENGTH) ; break;
	}
	break;
      case CHOICE_BODY_RADIUS_TYPE :
	switch (choiceVal) {
	case 0 : v_MeshVecField.bodyRadiusType.setValue(PoMesh2DVec.BodyRadiusTypes.CONSTANT_RADIUS) ; break;
	case 1 : v_MeshVecField.bodyRadiusType.setValue(PoMesh2DVec.BodyRadiusTypes.RELATIVE_RADIUS) ; break;
	}
	break;
      case CHOICE_BODY_COLORING_TYPE:
	switch (choiceVal) {
	case 0 : v_MeshVecField.bodyColoringType.setValue(PoMesh2DVec.ArrowColoringTypes.CONSTANT_COLOR) ; break;
	case 1 : v_MeshVecField.bodyColoringType.setValue(PoMesh2DVec.ArrowColoringTypes.MODULE_MAPPING_COLOR) ; break;
	case 2 : v_MeshVecField.bodyColoringType.setValue(PoMesh2DVec.ArrowColoringTypes.SCALAR_MAPPING_COLOR) ; break;
	}
	break;
      case CHOICE_START_ARROW_SHAPE:
	switch (choiceVal) {
	case 0 : v_MeshVecField.startArrowShape.setValue(PoMesh2DVec.ArrowShapes.NO_SHAPE) ; break;
	case 1 : v_MeshVecField.startArrowShape.setValue(PoMesh2DVec.ArrowShapes.POINT) ; break;
	case 2 : v_MeshVecField.startArrowShape.setValue(PoMesh2DVec.ArrowShapes.CHEVRON) ; break;
	case 3 : v_MeshVecField.startArrowShape.setValue(PoMesh2DVec.ArrowShapes.TRIANGLE) ; break;
	case 4 : v_MeshVecField.startArrowShape.setValue(PoMesh2DVec.ArrowShapes.RECTANGLE) ; break;
	case 5 : v_MeshVecField.startArrowShape.setValue(PoMesh2DVec.ArrowShapes.CONE) ; break;
	case 6 : v_MeshVecField.startArrowShape.setValue(PoMesh2DVec.ArrowShapes.BOX) ; break;
	case 7 : v_MeshVecField.startArrowShape.setValue(PoMesh2DVec.ArrowShapes.SPHERE) ; break;
	case 8 : v_MeshVecField.startArrowShape.setValue(PoMesh2DVec.ArrowShapes.INDIRECT_CHEVRON) ; break;
	case 9 : v_MeshVecField.startArrowShape.setValue(PoMesh2DVec.ArrowShapes.INDIRECT_TRIANGLE) ; break;
	case 10: v_MeshVecField.startArrowShape.setValue(PoMesh2DVec.ArrowShapes.INDIRECT_CONE) ; break;
	}
	break;
      case CHOICE_START_ARROW_HEIGHT_TYPE:
	switch (choiceVal) {
	case 0 : v_MeshVecField.startArrowHeightType.setValue(PoMesh2DVec.ArrowHeightTypes.CONSTANT_HEIGHT) ; break;
	case 1 : v_MeshVecField.startArrowHeightType.setValue(PoMesh2DVec.ArrowHeightTypes.RELATIVE_HEIGHT) ; break;
	}
	break;
      case CHOICE_START_ARROW_COLORING_TYPE:
	switch (choiceVal) {
	case 0 : v_MeshVecField.startArrowColoringType.setValue(PoMesh2DVec.ArrowColoringTypes.CONSTANT_COLOR) ; break;
	case 1 : v_MeshVecField.startArrowColoringType.setValue(PoMesh2DVec.ArrowColoringTypes.MODULE_MAPPING_COLOR) ; break;
	case 2 : v_MeshVecField.startArrowColoringType.setValue(PoMesh2DVec.ArrowColoringTypes.SCALAR_MAPPING_COLOR) ; break;
	}
	break;
      case CHOICE_END_ARROW_SHAPE:
	switch (choiceVal) {
	case 0 : v_MeshVecField.endArrowShape.setValue(PoMesh2DVec.ArrowShapes.NO_SHAPE) ; break;
	case 1 : v_MeshVecField.endArrowShape.setValue(PoMesh2DVec.ArrowShapes.POINT) ; break;
	case 2 : v_MeshVecField.endArrowShape.setValue(PoMesh2DVec.ArrowShapes.CHEVRON) ; break;
	case 3 : v_MeshVecField.endArrowShape.setValue(PoMesh2DVec.ArrowShapes.TRIANGLE) ; break;
	case 4 : v_MeshVecField.endArrowShape.setValue(PoMesh2DVec.ArrowShapes.RECTANGLE) ; break;
	case 5 : v_MeshVecField.endArrowShape.setValue(PoMesh2DVec.ArrowShapes.CONE) ; break;
	case 6 : v_MeshVecField.endArrowShape.setValue(PoMesh2DVec.ArrowShapes.BOX) ; break;
	case 7 : v_MeshVecField.endArrowShape.setValue(PoMesh2DVec.ArrowShapes.SPHERE) ; break;
	case 8 : v_MeshVecField.endArrowShape.setValue(PoMesh2DVec.ArrowShapes.INDIRECT_CHEVRON) ; break;
	case 9 : v_MeshVecField.endArrowShape.setValue(PoMesh2DVec.ArrowShapes.INDIRECT_TRIANGLE) ; break;
	case 10: v_MeshVecField.endArrowShape.setValue(PoMesh2DVec.ArrowShapes.INDIRECT_CONE) ; break;
	}
	break;
      case CHOICE_END_ARROW_HEIGHT_TYPE:
	switch (choiceVal) {
	case 0 : v_MeshVecField.endArrowHeightType.setValue(PoMesh2DVec.ArrowHeightTypes.CONSTANT_HEIGHT) ; break;
	case 1 : v_MeshVecField.endArrowHeightType.setValue(PoMesh2DVec.ArrowHeightTypes.RELATIVE_HEIGHT) ; break;
	}
	break;
      case CHOICE_END_ARROW_COLORING_TYPE:
	switch (choiceVal) {
	case 0 : v_MeshVecField.endArrowColoringType.setValue(PoMesh2DVec.ArrowColoringTypes.CONSTANT_COLOR) ; break;
	case 1 : v_MeshVecField.endArrowColoringType.setValue(PoMesh2DVec.ArrowColoringTypes.MODULE_MAPPING_COLOR) ; break;
	case 2 : v_MeshVecField.endArrowColoringType.setValue(PoMesh2DVec.ArrowColoringTypes.SCALAR_MAPPING_COLOR) ; break;
	}
	break;
      }
    }
  }

  class ListenButton implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      SoWriteAction writeAction = new SoWriteAction() ;
      writeAction.getOutput().openFile(fileName) ;
      writeAction.getOutput().setBinary(false) ;
      writeAction.apply(v_Root) ;
      writeAction.getOutput().closeFile() ;
    }
  }

  class ListenCheckbox implements ItemListener {
    int type ;
    public ListenCheckbox(int type) { this.type = type ; }
    public void itemStateChanged(ItemEvent e) {
      switch(type) {
      case TOGGLE_LINES:
	if (v_MeshLinesSwitch.whichChild.getValue() == SoSwitch.SO_SWITCH_ALL)
	  v_MeshLinesSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
	else
	  v_MeshLinesSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
	break;
      case TOGGLE_VEC_FIELD:
	if (v_MeshVecFieldSwitch.whichChild.getValue() == SoSwitch.SO_SWITCH_ALL)
	  v_MeshVecFieldSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
	else
	  v_MeshVecFieldSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
	break;
      }
    }
  }

  class ListenSlider extends SliderPanel.Listener
  {
    int type;

    public ListenSlider(int type)
    {
      this.type = type;
    }

    @Override
    public void stateChanged(float value)
    {
      switch ( type )
      {
      case SLIDER_MIN_LEN :
        v_MeshVecField.minLength.setValue(value);
        break;
      case SLIDER_MAX_LEN :
        v_MeshVecField.maxLength.setValue(value);
        break;
      case SLIDER_BODY_LEN_FACTOR :
        v_MeshVecField.bodyLengthFactor.setValue(value);
        break;
      case SLIDER_BODY_RADIUS_FACTOR :
        v_MeshVecField.bodyRadiusFactor.setValue(value);
        break;
      case SLIDER_START_ARROW_HEIGHT_FACTOR :
        v_MeshVecField.startArrowHeightFactor.setValue(value);
        break;
      case SLIDER_START_ARROW_RADIUS_FACTOR :
        v_MeshVecField.startArrowRadiusFactor.setValue(value);
        break;
      case SLIDER_END_ARROW_HEIGHT_FACTOR :
        v_MeshVecField.endArrowHeightFactor.setValue(value);
        break;
      case SLIDER_END_ARROW_RADIUS_FACTOR :
        v_MeshVecField.endArrowRadiusFactor.setValue(value);
        break;
      case SLIDER_DENSITY :
        v_MeshVecField.density.setValue((int) value);
        break;
      }
    }
  }
}
