package meshviz.mesh.sample.dialog;

import java.awt.Panel;
import java.util.ArrayList;
import java.util.List;

/**
  *  PoAwtElementData
  *
  * Abstract class to define an AWT element.
  *
  * @author Rodolphe Albout
  * @author Laurent ISTIN
  * @author Loic Vigneras
  * @author Patrick Vigneras
  */
public abstract class PoAwtElementData extends Panel {

  // Constants
  // ---------

  public static final int INTEGER_SLIDER = 0;
  public static final int REAL_SLIDER = 1;
  public static final int TRIGGER_BUTTON = 2;
  public static final int CHOICE_BUTTON = 3;
  public static final int TOGGLE_BUTTON = 4;
  public static final int EDITABLE_TEXT = 5;
  public static final int LABEL = 6;
  public static final int OTHERS = 7;

  private static final int HEIGHT_CURRENT = 30;

  // Constructor
  // -----------

  protected PoAwtElementData () {
    super ();
    _ident = 0;
    _heightElement = HEIGHT_CURRENT;
    _listeners = new ArrayList<Listener>();
  }

  // Methods
  // -------

  /** Returns the type of the element.
    */
  public int getType () {
    return OTHERS;
  }

  /** Creates and returns a new element which is a copy of this element.
    */
  public PoAwtElementData copy () {
    return (PoAwtElementData) clone ();
  }
  protected abstract Object clone ();

  /** Set an identifier. It allows the application to store an integer
    * in order to identify the element.
    */
  public void setID (int ident) {
    _ident = ident;
  }

  /** Get an identifier. It allows the applicationto store an integer
    * in order to identify the element.
    */
  public int getID () {
    return _ident;
  }

  public int getHeightElement () {
    return _heightElement;
  }
  protected void setHeightElement (int height) {
    _heightElement = height;
  }

  /** Affect the internal data awtElement to current object.
    * The current object and awtElement have to be the same object type.
    * This method should be called by PoAwtDialog, and not by user code
    * directly.
    */
  public abstract void updateValues (PoAwtElementData element);

  /** Minimum width for the label of the element.
    * The mimimum width for a elementid with no label will be 0 (Default behaviour).
    * The width is the size in pixel.
    * This method should be called by PoAwtDialog, and not by user code
    * directly.
    */
  public int getMinLabelWidth () {
    return 0;
  }
  /** Set the width of label, it's a pixel value.
    * This method should be called by PoAwtDialog, and not by user code
    * directly.
    */
  public void setMinLabelWidth (int minWidth) {
  }

  /** This is call when the dialog is resized, It's use for resize some awtElement.
    * This method should be called by PoAwtDialog, and not by user code
    * directly.
    */
  public void setPositionElementIfResize () {
  }

  // Listeners
  protected void addListener(Listener listener)
  {
    if ( listener != null )
      _listeners.add(listener);
  }

  protected void removeListener(Listener listener)
  {
    _listeners.remove(listener);
  }

  protected void invokeValueChanged()
  {
    for ( Listener listener : _listeners )
      listener.valueChanged();
  }

  // Fields
  // ------

  private int _heightElement;
  private int _ident;
  private List<Listener> _listeners;

  public static class Listener
  {
    public void valueChanged()
    {};
  }
}
