package meshviz.mesh.sample.meshLevelSurf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.meshviz.data.PbMesh;
import com.openinventor.meshviz.data.PoMesh;
import com.openinventor.meshviz.data.PoMeshLevelSurf;
import com.openinventor.meshviz.nodes.PoCartesianGrid3D;
import com.openinventor.meshviz.nodes.PoNonLinearDataMapping2;
import com.openinventor.util.AsciiStreamReader;

import meshviz.mesh.sample.MeshViewer;
import util.Example;
import util.ViewerComponentsFactory;
/**
  * Draws some isosurfaces on a 3D grid mesh. Each isosurface
  * is colored relating to its value.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private int numX = 32, numY = 32, numZ = 30 ;
  private IViewerExaminer myViewer;

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Level surfaces");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    String oivjhome = SoPreferences.getValue("OIVJHOME");
    PoCartesianGrid3D mesh = readFiles(oivjhome + "/data/mesh/poi3z32.txt", oivjhome + "/data/mesh/poi3v32.txt");
    if (mesh == null) return;

    PbMesh pb_mesh = mesh.getMesh();

    // get the min-max value of this set
    float vmin = pb_mesh.getMinValuesSet(0);
    float vmax = pb_mesh.getMaxValuesSet(0);

    // define a data-mapping associated to this data-set
    SbColor[] colors = {new SbColor(0,0,1), new SbColor(0,1,1), new SbColor(0,1,0),
			new SbColor(1,1,0), new SbColor(1,0,0)} ;
    float[] val = new float[5];
    val[0] = vmin; for (int j=1 ; j<5 ; j++) val[j] = val[j-1]+ (vmax-vmin)/4F;

    PoNonLinearDataMapping2 v_DataMapping = new PoNonLinearDataMapping2();
    v_DataMapping.type.setValue(PoNonLinearDataMapping2.Types.LINEAR_PER_LEVEL);
    v_DataMapping.color.setValues(0,colors);
    v_DataMapping.value.setValues(0,val);

    // define the scene-graph root
    SoSeparator root = new SoSeparator();
    root.addChild(v_DataMapping);
    root.addChild(mesh);

    int numLevel = 4;
    float deltaLevel = (vmax-vmin)/numLevel, level = vmin+deltaLevel/2F;

    // define the level surface

    for (int i=0 ; i<numLevel ; i++, level+=deltaLevel) {
      PoMeshLevelSurf v_MeshLevelSurf = new PoMeshLevelSurf();
      v_MeshLevelSurf.valuesIndex.setValue(0);
      v_MeshLevelSurf.coloringType.setValue(PoMesh.ColoringTypes.COLOR_MAPPING);
      v_MeshLevelSurf.levelValue.setValue(level);
      root.addChild(v_MeshLevelSurf);
    }

    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    printTrace ("Displaying the viewer...");
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  private PoCartesianGrid3D readFiles (String topoFile, String dataFile) {

    URL url_topo = MeshViewer.getURL(topoFile);

    if (url_topo == null) return null;

    URL url_data = MeshViewer.getURL(dataFile);
    if (url_data == null) return null;

    PoCartesianGrid3D mesh = null;

    AsciiStreamReader stream = null;
    try {
      int i ,j ,k ;

      stream = new AsciiStreamReader(url_topo.openStream()) ;
      printTrace("Start reading file "+topoFile+"...");
      float[] z = new float[numX*numY*numZ] ;
      for(k=0 ; k<numZ ; k++) {
	for(j=0 ; j<numY ; j++) {
	  for(i=0 ; i<numX ; i++) {
	    z[i*numY*numZ+j*numZ+k] = stream.readNextFloat() ;
	  }
	}
      }

      stream = new AsciiStreamReader(url_data.openStream()) ;
      printTrace("Start reading file "+dataFile+"...");
      float[]v = new float[numX*numY*numZ] ;
      for(k=0 ; k<numZ ; k++) {
	for(j=0 ; j<numY ; j++) {
	  for(i=0 ; i<numX ; i++) {
	    v[i*numY*numZ+j*numZ+k] = stream.readNextFloat() ;
	  }
	}
      }

      float[] x = new float[numX*numY*numZ] ;
      float[] y = new float[numX*numY*numZ] ;

      float xc ,yc ,dc ;
      dc = 625;
      xc = 0;
      for(i=0 ; i<numX ; i++) {
	for(j=0 ; j<numY ; j++) {
	  for(k=0 ; k<numZ ; k++) {
	    x[i*numY*numZ+j*numZ+k] = xc;
	  }
	}
	xc += dc;
      }

      yc = 0;
      for(j=0 ; j<numY ; j++) {
	for(i=0 ; i<numX ; i++) {
	  for(k=0 ; k<numZ ; k++) {
	    y[i*numY*numZ+j*numZ+k] = yc;
	  }
	}
	yc += dc;
      }

      mesh = new PoCartesianGrid3D();
      mesh.setGeometry(numX,numY,numZ, x,y,z);

      // add a set of scalar values to this mesh
      mesh.addValuesSet(0,v);

    }
    catch (Exception e) {
      System.err.println (e.toString());
      mesh = null;
    }

    return mesh;

  }


  private void printTrace (String message) {
    System.err.println (message);
  }
}
