package meshviz.mesh.sample.polarGrid2DVec;

import java.awt.BorderLayout;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.meshviz.nodes.PoPolarGrid2D;

import meshviz.mesh.sample.Vec2DViewer;
import util.Example;

/**
  * Draws a vector field on a 2D polar grid mesh. Draws the edges
  * of the mesh. Controls the aspect of the arrows representing
  * the vector field.
  *
  * @author Loic Vigneras
  * @author Patrick Vigneras
  * @author Jean Kinda
  */
public class Main extends Example
{

  private Vec2DViewer viewer;

  @Override
  public void start() {
    int numR = 3, numT = 3 ;
    float[] r = {0.1F,0.5F,1.0F} ;
    float[] t = {0.1F,0.5F,1.0F} ;
    float[] val = new float[numR*numT], alt = new float[numR*numT] ;
    SbVec3f[] vec = new SbVec3f[numR*numT] ;

    PoPolarGrid2D mesh = new PoPolarGrid2D();
    mesh.setGeometry(numR, numT, r, t) ;

    for (int i=0 ; i<numR ; i++)
      for (int j=0 ; j<numT ; j++) {
	int ij = i*numR + j;
	val[ij] = i * (numT-j);
	alt[ij] = 0;
	vec[ij] = new SbVec3f(0.05F*(j+1), 0.05F*(i+1),0);
      }
    alt[numR+1] = 0.2F ;

    mesh.addValuesSet(0,val);
    mesh.addValuesSet(1,alt);
    mesh.addVecsSet(0,vec);

    viewer = new Vec2DViewer();
    viewer.setFileName("PoPolarGrid2D.iv") ;
    viewer.show(mesh) ;
    viewer.getViewer().viewAll();

    viewer.getViewer().getComponent().setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(viewer);

  }

  @Override
  public void stop()
  {
    viewer.getViewer().dispose();
  }

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("PoPolarGrid2D");
  }
}
