package meshviz.mesh.sample.turbomeca;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URL;

import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.meshviz.nodes.PoHexahedronMesh3D;
import com.openinventor.meshviz.nodes.PoMeshProperty;
import com.openinventor.util.AsciiStreamReader;

import meshviz.mesh.sample.Mesh3DViewer;
import meshviz.mesh.sample.MeshViewer;
import util.Example;

/**
  * @author Jean Michel Godinaud
  * @author Rodolphe Albout
  * @author Laurent ISTIN
  * @author Loic Vigneras
  * @author Patrick Vigneras
  */
public class Main extends Example
{
  static private boolean ReadIvFile=true;

  private Mesh3DViewer meshViewer;

  public static void main(String[] argv) {
    Main example = new Main();
    example.demoMain("Turbomeca");
  }

  @Override
  public void start () {
    meshViewer = new Mesh3DViewer ();

    String oivjhome = SoPreferences.getValue("OIVJHOME");
    PoMeshProperty mesh;
    if (!ReadIvFile) {
        URL url = MeshViewer.getURL(oivjhome + "/data/models/TURBO.DAT");
        if (url == null) return;

        mesh = readFile (url);
        if (mesh == null) return;
    } else {
      File f =  new File(oivjhome + "/data/models/TURBO_56520_b.iv");
      URL url = null;
      try {
        url = f.toURI().toURL();
      }
      catch (Exception e) {
        e.printStackTrace();
      }

      SoInput in = new SoInput();
      if (!in.openURL(url)) {
        System.out.println("cannot open " + url);
        return;
      }

      if (!in.isValidFile())return;

      printTrace("Start reading mesh description...");
      SoSeparator root = SoDB.readAll(in);
      printTrace("End reading mesh description");

      mesh = (PoMeshProperty) root.getChild(0);
    }
    // dataSetName must have as many element as numDataSet value
    final String[] dataSetName = {
      "density",
      "momentum U",
      "momentum V",
      "momentum W",
      "enthalpy"
    };

    meshViewer.setDataSetNames (dataSetName);
    meshViewer.setWindowTitle ("PoHexahedronMesh3D");
    meshViewer.setCourtesyTitle ("by courtesy of Turbomeca");
    meshViewer.setPlaneNormal (new SbVec3f (0, 0, 1));
    meshViewer.setVecFieldDensity (12);
    meshViewer.setVecLengthFactor (0.004f);
    printTrace ("Example ready, displaying the viewer.");

    // Define a gridBag layout for the blue margin
    GridBagLayout gridbag = new GridBagLayout ();
    GridBagConstraints c = new GridBagConstraints ();
    c.insets = new Insets (5,5,5,5);
    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1.0;
    c.weighty = 1.0;
    gridbag.setConstraints (meshViewer, c);

    meshViewer.show(mesh);

    setLayout(gridbag);
    add(meshViewer);
  }

  @Override
  public void stop()
  {
    meshViewer.destroy();
  }

  private PoHexahedronMesh3D readFile(URL URLName) {
    PoHexahedronMesh3D mesh = null;
    AsciiStreamReader meshFile;
    try {
      final int numDataSet = 5;
      int numNodes;
      int numHexadrons;
      int[] hexahedronNodes;
      float[] xm, ym, zm;
      float[][] vm;
      SbVec3f[] vec;

      // Open stream
      printTrace ("Reading file  " + URLName.getFile());
      meshFile = new AsciiStreamReader(URLName.openStream());

      // Read number of nodes and hexahedrons
      numHexadrons = meshFile.readNextInt ();
      numNodes = meshFile.readNextInt ();
      printTrace ("Reading " + numHexadrons + " hexahedrons and " +
		  numNodes + " nodes coordinates");

      // Read hexahedrons
      hexahedronNodes = new int[8 * numHexadrons];
      for (int i = 0; i < 8 * numHexadrons; i++)
	hexahedronNodes[i] = meshFile.readNextInt ();

      // Read nodes
      xm = new float[numNodes];
      ym = new float[numNodes];
      zm = new float[numNodes];
      for (int i = 0; i < numNodes; i++) {
	xm[i] = meshFile.readNextFloat ();
	ym[i] = meshFile.readNextFloat ();
	zm[i] = meshFile.readNextFloat ();
      }

      printTrace ("Reading " + numDataSet + " data set values");
      vm = new float[numDataSet][numNodes];
      for (int i = 0; i < numNodes; i++)
	for (int iDataSet = 0; iDataSet < numDataSet; iDataSet++)
	  vm[iDataSet][i] = meshFile.readNextFloat ();

      // End of reading
      printTrace ("End reading file. Creating Scene graph.");

      // creating the mesh
      mesh = new PoHexahedronMesh3D();
      mesh.setGeometry(numNodes, xm, ym, zm, numHexadrons,hexahedronNodes);

      for (int i=0 ; i<numDataSet ; i++) mesh.addValuesSet (i, vm[i]);

      vec = new SbVec3f[numNodes];
      for (int i=0 ; i<numNodes ; i++) vec[i] = new SbVec3f(vm[1][i], vm[2][i], vm[3][i]) ;

      mesh.addVecsSet (0, vec);

    }
    catch (Exception e) {
      printTrace (e.toString());
      mesh = null;
    }

    return mesh;
  }


  private void printTrace (String message) {
    System.err.println (message);
  }
}
