package meshvizxlm.eclipsemeshviz;

import com.openinventor.inventor.SoPreferences;

public class DemoSettings
{
  public enum GridType
  {
    E_GRID, JIK_GRID
  };

  public enum MeshType
  {
    FULLCACHE, TOPOCACHE, NOCACHE
  }

  public final static GridType GRID_TYPE = GridType.JIK_GRID;

  public final static boolean HORIZONTAL_FAULTS = false;

  public final static boolean LOW_RES_TIMINGS = false;

  public final static String DEFAULT_EGRID_FILE_NAME = "demo_grid_1M.bin";
  public final static String DEFAULT_JIK_FILE_NAME = "demo_grid_1M.jik.bin";

  public static final MeshType DEFAULT_MESH_TYPE = MeshType.TOPOCACHE;

  public static final boolean SHOW_MESHTYPE_PANEL = false;

  private static boolean s_display_timer = true;

  public static void displayTime(String what, double elapsedTime)
  {
    double seconds = elapsedTime / 1000;
    if ( s_display_timer )
      System.out.println(what + " in " + seconds + " seconds");
  }

  public static final int BACK_TO_FULL_RES_TIME = 5; // sec

  public static final double LOW_RESOLUTION_EXTRACTION_TIME_REFERENCE1 = 100; // ms

  /**
   * Warning: please notice that ASYNC PROCESSING is a preview feature only.
   * <p>
   * Setting the MESHVIZ_ASYNC_PROCESSING environment variable to true allows a
   * better user interactivity. It enforces any MeshViz XLM skin & slab
   * extractions to be launched in background without blocking the graphic user
   * interface of the application. As a preview feature, this new behavior is
   * not yet fully completed and this environment variable could be ignored at
   * any time in future releases.
   */
  public static final boolean ASYNC_PROCESSING = SoPreferences.getBoolean("MESHVIZ_ASYNC_PROCESSING", false);

}
