package meshvizxlm.eclipsemeshviz;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;

import javax.swing.JFrame;
import javax.swing.UIManager;

import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.actions.SoGLRenderAction.TransparencyTypes;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;

import meshvizxlm.eclipsemeshviz.DemoSettings.GridType;
import meshvizxlm.eclipsemeshviz.gui.EclipseMeshVizFrame;
import meshvizxlm.eclipsemeshviz.gui.ScenegraphManager;
import meshvizxlm.eclipsemeshviz.scenegraph.MeshReader;
import meshvizxlm.eclipsemeshviz.scenegraph.OivSceneGraph;
import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  private EclipseMeshVizFrame m_frame;
  private IViewerExaminer m_renderArea;

  @Override
  public void start()
  {
    String meshvizxlmDataPrefix = SoPreferences.getValue("OIVJHOME") + File.separator + "examples" + File.separator
        + "meshvizxlm" + File.separator + "data";
    String[] pkgNameSplit = this.getClass().getPackage().getName().split("\\.");
    String demoDataPrefix =
        meshvizxlmDataPrefix + File.separator + pkgNameSplit[pkgNameSplit.length - 1] + File.separator;
    File defaultFile;
    if ( DemoSettings.GRID_TYPE == GridType.E_GRID )
    {
      defaultFile = new File(demoDataPrefix + DemoSettings.DEFAULT_EGRID_FILE_NAME);
    }
    else
    {
      defaultFile = new File(demoDataPrefix + DemoSettings.DEFAULT_JIK_FILE_NAME);
    }

    m_renderArea = ViewerComponentsFactory.createViewerExaminer();

    OivSceneGraph scenegraph = new OivSceneGraph();
    ScenegraphManager sceneManager = new ScenegraphManager(m_renderArea, scenegraph);

    m_renderArea.getRenderArea().getSceneInteractor().addInteractionModeListener(sceneManager);
    m_renderArea.getRenderArea().setTransparencyType(TransparencyTypes.OPAQUE_FIRST);
    m_renderArea.setSceneGraph(scenegraph.getRoot());

    m_frame = new EclipseMeshVizFrame();
    m_frame.registerListeners(sceneManager);

    MeshReader.getInstance().clearListeners();
    MeshReader.getInstance().addListener(sceneManager);
    MeshReader.getInstance().addListener(m_frame);

    // Init
    MeshReader.getInstance().init(DemoSettings.DEFAULT_MESH_TYPE, defaultFile);

    sceneManager.attachTriangleSensor();
    m_renderArea.viewAll();

    final Component component = m_renderArea.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);

    m_frame.setVisible(true);
    m_frame.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
  }

  @Override
  public void stop()
  {
    if ( !System.getProperty("os.name").startsWith("Mac") )
    {
      // restore default L&F
      try
      {
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
      }
      catch (Exception exc)
      {
        System.out.println("cannot restore look and feel " + exc.getMessage());
      }
    }
    m_frame.dispose();
    m_renderArea.dispose();
  }

  public static void main(String[] args)
  {
    Main example = new Main();
    example.demoMain("Eclipse MeshViz");
    example.m_frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
  }

}
