package meshvizxlm.eclipsemeshviz.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

@SuppressWarnings("serial")
public class FilteringPanel extends SliderPanelContainer<FilteringPanel.FilteringListener>
{

  private JCheckBox m_activeCheckBox;
  private JCheckBox m_reverseCheckBox;
  private SliderPanel m_iMinSliderPanel;
  private SliderPanel m_iMaxSliderPanel;
  private SliderPanel m_jMinSliderPanel;
  private SliderPanel m_jMaxSliderPanel;
  private SliderPanel m_kMinSliderPanel;
  private SliderPanel m_kMaxSliderPanel;
  private SliderPanel m_dMinSliderPanel;
  private SliderPanel m_dMaxSliderPanel;

  private ArrayList<FilteringListener> m_listeners;

  /**
   * Create the panel.
   */
  public FilteringPanel()
  {
    m_listeners = new ArrayList<FilteringPanel.FilteringListener>();

    buildUI();
    addListeners();

    m_iMinSliderPanel.setEnabled(false);
    m_iMaxSliderPanel.setEnabled(false);
    m_jMinSliderPanel.setEnabled(false);
    m_jMaxSliderPanel.setEnabled(false);
    m_kMinSliderPanel.setEnabled(false);
    m_kMaxSliderPanel.setEnabled(false);
    m_dMinSliderPanel.setEnabled(false);
    m_dMaxSliderPanel.setEnabled(false);
  }

  public void addROIListener(FilteringListener listener)
  {
    m_listeners.add(listener);
  }

  public void updateROI(int imin, int imax, int jmin, int jmax, int kmin, int kmax)
  {
    m_iMinSliderPanel.setSliderMin(imin);
    m_iMinSliderPanel.setSliderMax(imax);
    m_iMaxSliderPanel.setSliderMin(imin);
    m_iMaxSliderPanel.setSliderMax(imax);

    m_iMinSliderPanel.setSliderValue(imin);
    m_iMaxSliderPanel.setSliderValue(imax);

    m_jMinSliderPanel.setSliderMin(jmin);
    m_jMinSliderPanel.setSliderMax(jmax);
    m_jMaxSliderPanel.setSliderMin(jmin);
    m_jMaxSliderPanel.setSliderMax(jmax);

    m_jMinSliderPanel.setSliderValue(jmin);
    m_jMaxSliderPanel.setSliderValue(jmax);

    m_kMinSliderPanel.setSliderMin(kmin);
    m_kMinSliderPanel.setSliderMax(kmax);
    m_kMaxSliderPanel.setSliderMin(kmin);
    m_kMaxSliderPanel.setSliderMax(kmax);

    m_kMinSliderPanel.setSliderValue(kmin);
    m_kMaxSliderPanel.setSliderValue(kmax);
  }

  public void updateDataRange(float min, float max)
  {
    m_dMinSliderPanel.setSliderMin(min);
    m_dMinSliderPanel.setSliderMax(max);
    m_dMinSliderPanel.setSliderValue(min);

    m_dMaxSliderPanel.setSliderMin(min);
    m_dMaxSliderPanel.setSliderMax(max);
    m_dMaxSliderPanel.setSliderValue(max);
  }

  @Override
  public String toString()
  {
    return "Filtering";
  }

  private void buildUI()
  {
    GridBagLayout gridBagLayout = new GridBagLayout();
    gridBagLayout.columnWidths = new int[] { 0, 0, 0, 0, 0, 0 };
    gridBagLayout.rowHeights = new int[] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
    gridBagLayout.columnWeights = new double[] { 0.0, 1.0, 0.0, 1.0, 1.0, Double.MIN_VALUE };
    gridBagLayout.rowWeights = new double[] { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE };
    setLayout(gridBagLayout);

    m_activeCheckBox = new JCheckBox("Active");
    GridBagConstraints gbc_activeCheckBox = new GridBagConstraints();
    gbc_activeCheckBox.ipady = 20;
    gbc_activeCheckBox.anchor = GridBagConstraints.WEST;
    gbc_activeCheckBox.gridwidth = 2;
    gbc_activeCheckBox.insets = new Insets(0, 0, 5, 5);
    gbc_activeCheckBox.gridx = 0;
    gbc_activeCheckBox.gridy = 0;
    add(m_activeCheckBox, gbc_activeCheckBox);

    JPanel ROIpanel = new JPanel();
    ROIpanel.setBorder(new TitledBorder(null, "ROI Filtering", TitledBorder.LEADING, TitledBorder.TOP, null, null));
    GridBagConstraints gbc_ROIpanel = new GridBagConstraints();
    gbc_ROIpanel.fill = GridBagConstraints.VERTICAL;
    gbc_ROIpanel.gridx = 0;
    gbc_ROIpanel.gridy = 1;
    add(ROIpanel, gbc_ROIpanel);
    GridBagLayout gbl_ROIpanel = new GridBagLayout();
    gbl_ROIpanel.columnWidths = new int[] { 0, 0, 0 };
    gbl_ROIpanel.rowHeights = new int[] { 0, 0, 0 };
    gbl_ROIpanel.columnWeights = new double[] { 0.0, 1.0, Double.MIN_VALUE };
    gbl_ROIpanel.rowWeights = new double[] { 0.0, 0.0, Double.MIN_VALUE };
    ROIpanel.setLayout(gbl_ROIpanel);

    JLabel lblIMin = new JLabel("i min");
    GridBagConstraints gbc_lblIMin = new GridBagConstraints();
    gbc_lblIMin.anchor = GridBagConstraints.EAST;
    gbc_lblIMin.insets = new Insets(0, 0, 0, 5);
    gbc_lblIMin.gridx = 0;
    gbc_lblIMin.gridy = 1;
    ROIpanel.add(lblIMin, gbc_lblIMin);

    m_iMinSliderPanel = new SliderPanel(0, 0, 0);
    GridBagConstraints gbc_iMinSliderPanel = new GridBagConstraints();
    gbc_iMinSliderPanel.anchor = GridBagConstraints.WEST;
    gbc_iMinSliderPanel.insets = new Insets(0, 0, 0, 5);
    gbc_iMinSliderPanel.fill = GridBagConstraints.VERTICAL;
    gbc_iMinSliderPanel.gridx = 1;
    gbc_iMinSliderPanel.gridy = 1;
    ROIpanel.add(m_iMinSliderPanel, gbc_iMinSliderPanel);

    JLabel lblIMax = new JLabel("i max");
    GridBagConstraints gbc_lblIMax = new GridBagConstraints();
    gbc_lblIMax.anchor = GridBagConstraints.EAST;
    gbc_lblIMax.insets = new Insets(0, 0, 5, 5);
    gbc_lblIMax.gridx = 0;
    gbc_lblIMax.gridy = 2;
    ROIpanel.add(lblIMax, gbc_lblIMax);

    m_iMaxSliderPanel = new SliderPanel(0, 0, 0);
    GridBagConstraints gbc_iMaxSliderPanel = new GridBagConstraints();
    gbc_iMaxSliderPanel.anchor = GridBagConstraints.WEST;
    gbc_iMaxSliderPanel.insets = new Insets(0, 0, 5, 5);
    gbc_iMaxSliderPanel.fill = GridBagConstraints.VERTICAL;
    gbc_iMaxSliderPanel.gridx = 1;
    gbc_iMaxSliderPanel.gridy = 2;
    ROIpanel.add(m_iMaxSliderPanel, gbc_iMaxSliderPanel);

    JLabel lblJMin = new JLabel("j min");
    GridBagConstraints gbc_lblJMin = new GridBagConstraints();
    gbc_lblJMin.anchor = GridBagConstraints.EAST;
    gbc_lblJMin.insets = new Insets(0, 0, 0, 5);
    gbc_lblJMin.gridx = 0;
    gbc_lblJMin.gridy = 3;
    ROIpanel.add(lblJMin, gbc_lblJMin);

    m_jMinSliderPanel = new SliderPanel(0, 0, 0);
    GridBagConstraints gbc_jMinSliderPanel = new GridBagConstraints();
    gbc_jMinSliderPanel.anchor = GridBagConstraints.WEST;
    gbc_jMinSliderPanel.insets = new Insets(5, 0, 0, 5);
    gbc_jMinSliderPanel.fill = GridBagConstraints.VERTICAL;
    gbc_jMinSliderPanel.gridx = 1;
    gbc_jMinSliderPanel.gridy = 3;
    ROIpanel.add(m_jMinSliderPanel, gbc_jMinSliderPanel);

    JLabel lblJMax = new JLabel("j max");
    GridBagConstraints gbc_lblJMax = new GridBagConstraints();
    gbc_lblJMax.anchor = GridBagConstraints.EAST;
    gbc_lblJMax.insets = new Insets(0, 0, 5, 5);
    gbc_lblJMax.gridx = 0;
    gbc_lblJMax.gridy = 4;
    ROIpanel.add(lblJMax, gbc_lblJMax);

    m_jMaxSliderPanel = new SliderPanel(0, 0, 0);
    GridBagConstraints gbc_jMaxSliderPanel = new GridBagConstraints();
    gbc_jMaxSliderPanel.anchor = GridBagConstraints.WEST;
    gbc_jMaxSliderPanel.insets = new Insets(0, 0, 5, 5);
    gbc_jMaxSliderPanel.fill = GridBagConstraints.VERTICAL;
    gbc_jMaxSliderPanel.gridx = 1;
    gbc_jMaxSliderPanel.gridy = 4;
    ROIpanel.add(m_jMaxSliderPanel, gbc_jMaxSliderPanel);

    JLabel lblNewLabel = new JLabel("k min");
    GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
    gbc_lblNewLabel.anchor = GridBagConstraints.EAST;
    gbc_lblNewLabel.insets = new Insets(5, 0, 0, 5);
    gbc_lblNewLabel.gridx = 0;
    gbc_lblNewLabel.gridy = 5;
    ROIpanel.add(lblNewLabel, gbc_lblNewLabel);

    m_kMinSliderPanel = new SliderPanel(0, 0, 0);
    GridBagConstraints gbc_kMinSliderPanel = new GridBagConstraints();
    gbc_kMinSliderPanel.anchor = GridBagConstraints.WEST;
    gbc_kMinSliderPanel.insets = new Insets(5, 0, 0, 5);
    gbc_kMinSliderPanel.fill = GridBagConstraints.VERTICAL;
    gbc_kMinSliderPanel.gridx = 1;
    gbc_kMinSliderPanel.gridy = 5;
    ROIpanel.add(m_kMinSliderPanel, gbc_kMinSliderPanel);

    JLabel lblNewLabel_1 = new JLabel("k max");
    GridBagConstraints gbc_lblNewLabel_1 = new GridBagConstraints();
    gbc_lblNewLabel_1.anchor = GridBagConstraints.EAST;
    gbc_lblNewLabel_1.insets = new Insets(0, 0, 5, 5);
    gbc_lblNewLabel_1.gridx = 0;
    gbc_lblNewLabel_1.gridy = 6;
    ROIpanel.add(lblNewLabel_1, gbc_lblNewLabel_1);

    m_kMaxSliderPanel = new SliderPanel(0, 0, 0);
    GridBagConstraints gbc_kMaxSliderPanel = new GridBagConstraints();
    gbc_kMaxSliderPanel.anchor = GridBagConstraints.WEST;
    gbc_kMaxSliderPanel.insets = new Insets(0, 0, 5, 5);
    gbc_kMaxSliderPanel.fill = GridBagConstraints.VERTICAL;
    gbc_kMaxSliderPanel.gridx = 1;
    gbc_kMaxSliderPanel.gridy = 6;
    ROIpanel.add(m_kMaxSliderPanel, gbc_kMaxSliderPanel);

    JPanel Datapanel = new JPanel();
    Datapanel.setBorder(new TitledBorder(null, "Data Filtering", TitledBorder.LEADING, TitledBorder.TOP, null, null));
    GridBagConstraints gbc_datapanel = new GridBagConstraints();
    gbc_datapanel.fill = GridBagConstraints.VERTICAL;
    gbc_datapanel.gridx = 0;
    gbc_datapanel.gridy = 7;
    add(Datapanel, gbc_datapanel);
    GridBagLayout gbl_datapanel = new GridBagLayout();
    gbl_datapanel.columnWidths = new int[] { 0, 0, 0 };
    gbl_datapanel.rowHeights = new int[] { 0, 0, 0 };
    gbl_datapanel.columnWeights = new double[] { 0.0, 1.0, Double.MIN_VALUE };
    gbl_datapanel.rowWeights = new double[] { 0.0, 0.0, Double.MIN_VALUE };
    Datapanel.setLayout(gbl_datapanel);

    m_reverseCheckBox = new JCheckBox("Reverse");
    GridBagConstraints gbc_reverseCheckBox = new GridBagConstraints();
    gbc_reverseCheckBox.ipady = 20;
    gbc_reverseCheckBox.anchor = GridBagConstraints.WEST;
    gbc_reverseCheckBox.gridwidth = 2;
    gbc_reverseCheckBox.insets = new Insets(0, 0, 5, 5);
    gbc_reverseCheckBox.gridx = 0;
    gbc_reverseCheckBox.gridy = 7;
    m_reverseCheckBox.setEnabled(false);
    Datapanel.add(m_reverseCheckBox, gbc_reverseCheckBox);

    JLabel lblDataMin = new JLabel("data min");
    GridBagConstraints gbc_lblDataMin = new GridBagConstraints();
    gbc_lblDataMin.anchor = GridBagConstraints.EAST;
    gbc_lblDataMin.insets = new Insets(5, 0, 0, 5);
    gbc_lblDataMin.gridx = 0;
    gbc_lblDataMin.gridy = 8;
    Datapanel.add(lblDataMin, gbc_lblDataMin);

    m_dMinSliderPanel = new SliderPanel(0.f, 0.f, 0.f, 3);
    GridBagConstraints gbc_dMinSliderPanel = new GridBagConstraints();
    gbc_dMinSliderPanel.anchor = GridBagConstraints.WEST;
    gbc_dMinSliderPanel.insets = new Insets(5, 0, 0, 5);
    gbc_dMinSliderPanel.gridx = 1;
    gbc_dMinSliderPanel.gridy = 8;
    Datapanel.add(m_dMinSliderPanel, gbc_dMinSliderPanel);

    JLabel lblDataMax = new JLabel("data max");
    GridBagConstraints gbc_lblDataMax = new GridBagConstraints();
    gbc_lblDataMax.anchor = GridBagConstraints.EAST;
    gbc_lblDataMax.insets = new Insets(0, 2, 5, 5);
    gbc_lblDataMax.gridx = 0;
    gbc_lblDataMax.gridy = 9;
    Datapanel.add(lblDataMax, gbc_lblDataMax);

    m_dMaxSliderPanel = new SliderPanel(0.f, 0.f, 0.f, 3);
    GridBagConstraints gbc_dMaxSliderPanel = new GridBagConstraints();
    gbc_dMaxSliderPanel.anchor = GridBagConstraints.WEST;
    gbc_dMaxSliderPanel.insets = new Insets(0, 0, 5, 5);
    gbc_dMaxSliderPanel.gridx = 1;
    gbc_dMaxSliderPanel.gridy = 9;
    Datapanel.add(m_dMaxSliderPanel, gbc_dMaxSliderPanel);
  }

  private void addListeners()
  {
    m_activeCheckBox.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        boolean selected = e.getStateChange() == ItemEvent.SELECTED;

        for ( FilteringListener listener : m_listeners )
          listener.filteringActivated(selected);

        m_iMinSliderPanel.setEnabled(selected);
        m_iMaxSliderPanel.setEnabled(selected);
        m_jMinSliderPanel.setEnabled(selected);
        m_jMaxSliderPanel.setEnabled(selected);
        m_kMinSliderPanel.setEnabled(selected);
        m_kMaxSliderPanel.setEnabled(selected);
        m_dMinSliderPanel.setEnabled(selected);
        m_dMaxSliderPanel.setEnabled(selected);
        m_reverseCheckBox.setEnabled(selected);
      }
    });

    m_reverseCheckBox.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        boolean selected = e.getStateChange() == ItemEvent.SELECTED;

        for ( FilteringListener listener : m_listeners )
          listener.reverseChanged(selected);
      }
    });

    SliderPanel.Listener roiListener = new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        int imin = (int) m_iMinSliderPanel.getSliderValue();
        int imax = (int) m_iMaxSliderPanel.getSliderValue();
        int jmin = (int) m_jMinSliderPanel.getSliderValue();
        int jmax = (int) m_jMaxSliderPanel.getSliderValue();
        int kmin = (int) m_kMinSliderPanel.getSliderValue();
        int kmax = (int) m_kMaxSliderPanel.getSliderValue();

        for ( FilteringListener listener : m_listeners )
        {
          if ( !m_sliderDragStart )
            listener.startDownsampling();
          listener.filteringChanged(imin, imax, jmin, jmax, kmin, kmax);
        }
      }
    };

    m_iMinSliderPanel.addSliderPanelListener(roiListener);
    m_iMaxSliderPanel.addSliderPanelListener(roiListener);
    m_jMinSliderPanel.addSliderPanelListener(roiListener);
    m_jMaxSliderPanel.addSliderPanelListener(roiListener);
    m_kMinSliderPanel.addSliderPanelListener(roiListener);
    m_kMaxSliderPanel.addSliderPanelListener(roiListener);

    addDownsamplingBehaviours(m_iMinSliderPanel);
    addDownsamplingBehaviours(m_iMaxSliderPanel);
    addDownsamplingBehaviours(m_jMinSliderPanel);
    addDownsamplingBehaviours(m_jMaxSliderPanel);
    addDownsamplingBehaviours(m_kMinSliderPanel);
    addDownsamplingBehaviours(m_kMaxSliderPanel);

    SliderPanel.Listener dataRangeListener = new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {

        float min = m_dMinSliderPanel.getSliderValue();
        float max = m_dMaxSliderPanel.getSliderValue();

        for ( FilteringListener listener : m_listeners )
        {
          if ( !m_sliderDragStart )
            listener.startDownsampling();
          listener.dataRangeChanged(min, max);
        }
      }
    };

    m_dMinSliderPanel.addSliderPanelListener(dataRangeListener);
    m_dMaxSliderPanel.addSliderPanelListener(dataRangeListener);

    addDownsamplingBehaviours(m_dMinSliderPanel);
    addDownsamplingBehaviours(m_dMaxSliderPanel);
  }

  @Override
  protected ArrayList<FilteringListener> getDownsamplingListeners()
  {
    return m_listeners;
  }

  public interface FilteringListener extends DownsamplingListener
  {
    // fire when ROI is activated/deactivated
    public void filteringActivated(boolean active);

    // fire when ROI bounds changed
    public void filteringChanged(int imin, int imax, int jmin, int jmax, int kmin, int kmax);

    // fire when data range changed
    public void dataRangeChanged(float min, float max);

    // fire when reverse changed
    public void reverseChanged(boolean active);
  }
}
