package meshvizxlm.eclipsemeshviz.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;

@SuppressWarnings("serial")
public class IsosurfacePanel extends SliderPanelContainer<IsosurfacePanel.IsosurfaceMeshListener>
{

  private JCheckBox m_visibleCheckBox;
  private SliderPanel m_isosurfaceValuePanel;

  private ArrayList<IsosurfaceMeshListener> m_listeners;

  /**
   * Create the panel.
   */
  public IsosurfacePanel()
  {
    m_listeners = new ArrayList<IsosurfaceMeshListener>();
    m_sliderDragStart = true;
    buildUI();
    addListeners();

    m_isosurfaceValuePanel.setEnabled(false);
  }

  public void addIsosurfaceListener(IsosurfaceMeshListener listener)
  {
    m_listeners.add(listener);
  }

  public void updateDataRange(float min, float max)
  {
    m_isosurfaceValuePanel.setSliderMin(min);
    m_isosurfaceValuePanel.setSliderMax(max);
    m_isosurfaceValuePanel.setSliderValue((max + min) / 2.f);
  }

  @Override
  public String toString()
  {
    return "Isosurface";
  }

  private void buildUI()
  {
    GridBagLayout gridBagLayout = new GridBagLayout();
    gridBagLayout.rowWeights = new double[] { 0.0, 0.0, 0.0, 0.0, 0.0 };
    gridBagLayout.columnWeights = new double[] { 1.0 };
    setLayout(gridBagLayout);

    m_visibleCheckBox = new JCheckBox("Visible");
    GridBagConstraints gbc_visibleCheckBox = new GridBagConstraints();
    gbc_visibleCheckBox.anchor = GridBagConstraints.WEST;
    gbc_visibleCheckBox.insets = new Insets(0, 0, 5, 0);
    gbc_visibleCheckBox.gridx = 0;
    gbc_visibleCheckBox.gridy = 0;
    add(m_visibleCheckBox, gbc_visibleCheckBox);

    JPanel panel = new JPanel();
    GridBagConstraints gbc_panel = new GridBagConstraints();
    gbc_panel.fill = GridBagConstraints.VERTICAL;
    gbc_panel.anchor = GridBagConstraints.WEST;
    gbc_panel.gridx = 0;
    gbc_panel.gridy = 3;
    add(panel, gbc_panel);

    m_isosurfaceValuePanel = new SliderPanel(0, 0, 0, 3);
    m_isosurfaceValuePanel.addInfoText("Isosurface value");
    panel.add(m_isosurfaceValuePanel);
  }

  private void addListeners()
  {
    m_visibleCheckBox.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        boolean selected = e.getStateChange() == ItemEvent.SELECTED;

        for ( IsosurfaceMeshListener listener : m_listeners )
          listener.isosurfaceVisibilityChanged(selected);

        m_isosurfaceValuePanel.setEnabled(selected);
      }
    });

    m_isosurfaceValuePanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        for ( IsosurfaceMeshListener listener : m_listeners )
          listener.isosurfaceValueChanged(value);
      }
    });

    addDownsamplingBehaviours(m_isosurfaceValuePanel);
  }

  @Override
  protected ArrayList<IsosurfaceMeshListener> getDownsamplingListeners()
  {
    return m_listeners;
  }

  public interface IsosurfaceMeshListener extends DownsamplingListener
  {
    public void isosurfaceVisibilityChanged(boolean visible);

    public void isosurfaceValueChanged(float value);
  }
}
