package meshvizxlm.eclipsemeshviz.gui;

import java.util.ArrayList;

import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoSceneManager.AntialiasingModes;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.actions.SoGetPrimitiveCountAction;
import com.openinventor.inventor.sensors.SoNodeSensor;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.InteractionMode;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.InteractionModeListener;
import com.openinventor.meshvizxlm.mapping.nodes.MoPredefinedColorMapping.PredefColorMapping;
import com.openinventor.meshvizxlm.mesh.Dimension;

import meshvizxlm.eclipsemeshviz.gui.AnimationPanel.AnimationListener;
import meshvizxlm.eclipsemeshviz.gui.FilteringPanel.FilteringListener;
import meshvizxlm.eclipsemeshviz.gui.FullMeshPanel.FullMeshListener;
import meshvizxlm.eclipsemeshviz.gui.GeometryPanel.GeometryListener;
import meshvizxlm.eclipsemeshviz.gui.GeometrySlicePanel.GeometrySliceListener;
import meshvizxlm.eclipsemeshviz.gui.HullPanel.HullListener;
import meshvizxlm.eclipsemeshviz.gui.IsosurfacePanel.IsosurfaceMeshListener;
import meshvizxlm.eclipsemeshviz.gui.SlabAxisPanel.SlabListener;
import meshvizxlm.eclipsemeshviz.pillargrid.PillarGrid;
import meshvizxlm.eclipsemeshviz.scenegraph.OivSceneGraph;
import meshvizxlm.eclipsemeshviz.wrappers.PillarMesh;
import meshvizxlm.eclipsemeshviz.wrappers.property.BoundedProperty;

public class ScenegraphManager implements FilteringListener, GeometryListener, FullMeshListener, SlabListener,
    GeometrySliceListener, MeshChangedListener, IsosurfaceMeshListener, InteractionModeListener, AnimationListener,
    HullListener, RenderingOptionListener
{
  private IViewerExaminer m_renderArea;
  private OivSceneGraph m_sceneGraph;
  private ArrayList<DownsamplingParamListener> m_listeners = new ArrayList<DownsamplingParamListener>();
  private SoNodeSensor m_triangleNodesensor;

  private SoGetPrimitiveCountAction m_getPrimitiveAction;

  public ScenegraphManager(IViewerExaminer renderArea, OivSceneGraph scenegraph)
  {
    m_renderArea = renderArea;
    m_sceneGraph = scenegraph;

    m_getPrimitiveAction = new SoGetPrimitiveCountAction();

    m_triangleNodesensor = new SoNodeSensor(new Runnable()
    {

      @Override
      public void run()
      {
        // A GetBoundingBoxAction (called by viewAll) is processed in the main
        // thread while this GetPrimitiveAction is processed in the AWT EDT.
        // Use a write-lock to synchronize actions to prevent concurrent access
        // to the scene graph.
        SoDB.writelock();
        try
        {
          m_getPrimitiveAction.apply(m_sceneGraph.getRoot());
          int numTriangle = 0;
          numTriangle = m_getPrimitiveAction.getTriangleCount();
          m_sceneGraph.m_gridTriangleDisplay.string.set1Value(3, "# Triangles : " + numTriangle);
        }
        finally
        {
          SoDB.writeunlock();
        }
      }
    });

  }

  public void attachTriangleSensor()
  {
    m_sceneGraph.attachFullReshSceneGraph(m_triangleNodesensor);
  }

  @Override
  public void startDownsampling()
  {
    m_sceneGraph.startDownsampling();
  }

  @Override
  public void finishDownsampling()
  {
    m_sceneGraph.finishDownsampling();
  }

  @Override
  public void fullResolutionRequest()
  {
    m_sceneGraph.requestFullResolution();
  }

  @Override
  public void disableFullResolution()
  {
    m_sceneGraph.disableFullResolution();
  }

  @Override
  public void delayToFullResolutionChanged(int value)
  {
    m_sceneGraph.setDelayToFullResolution(value);
  }

  @Override
  public void autoDownsamplingStateChanged(boolean activate, double resolution)
  {
    m_sceneGraph.setAutoDownsamplingState(activate, resolution);
    for ( DownsamplingParamListener listener : m_listeners )
      listener.downsamplingParamChanged(m_sceneGraph.getLowResolution());
  }

  @Override
  public void downsamplingParamChanged(double resolution)
  {
    m_sceneGraph.setLowResolution(resolution);
    m_sceneGraph.updateLowResMesh();
    for ( DownsamplingParamListener listener : m_listeners )
      listener.downsamplingParamChanged(m_sceneGraph.getCurrentResolution());
  }

  @Override
  public void setPlaybackPosition(int value)
  {
    m_sceneGraph.setPlaybackPosition(value);
  }

  @Override
  public void interactionModeChanged(InteractionMode newMode)
  {
    if ( newMode == InteractionMode.NAVIGATION )
    {
      m_sceneGraph.enableFacesPicking(false);
      m_sceneGraph.displayGridInfo();
    }
    else
      m_sceneGraph.enableFacesPicking(true);
  }

  @Override
  public void seekModeChanged(boolean onOrOff)
  {}

  @Override
  public void isosurfaceVisibilityChanged(boolean visible)
  {
    m_sceneGraph.setIsosurfaceVisibility(visible);
  }

  @Override
  public void isosurfaceValueChanged(float value)
  {
    m_sceneGraph.setIsosurfaceValue(value);
  }

  @Override
  public void meshChanged(PillarMesh<PillarGrid> newMesh)
  {
    m_sceneGraph.setMesh(newMesh);
    m_renderArea.viewAll();
  }

  @Override
  public void sliceVisibilityChanged(boolean visible)
  {
    m_sceneGraph.setSliceVisibility(visible);
  }

  @Override
  public void sliceClippingChanged(boolean active)
  {
    m_sceneGraph.setSliceClipping(active);
  }

  @Override
  public void sliceRotAxisChanged(int axis)
  {
    m_sceneGraph.setSliceRotAxis(axis);
  }

  @Override
  public void sliceRotAngleChanged(int axis, float angle)
  {
    m_sceneGraph.setSliceRotAngle(axis, angle);
  }

  @Override
  public void slabVisibilityChanged(Dimension axis, boolean visible)
  {
    m_sceneGraph.setSlabVisibility(axis, visible);
  }

  @Override
  public void slabPositionChanged(Dimension axis, int position)
  {
    m_sceneGraph.setSlabPosition(axis, position);
  }

  @Override
  public void slabWidthChanged(Dimension axis, int width)
  {
    m_sceneGraph.setSlabWidth(axis, width);
  }

  @Override
  public void slabGapChanged(Dimension axis, int gap)
  {
    m_sceneGraph.setSlabGap(axis, gap);
  }

  @Override
  public void skinVisibilityChanged(boolean visible)
  {
    m_sceneGraph.setSkinVisibility(visible);
  }

  @Override
  public void skinMapPropertyChanged(boolean selected)
  {
    m_sceneGraph.setSkinColorProperty(selected ? 0 : -1);
  }

  @Override
  public void edgesVisibilityChanged(boolean visible)
  {
    m_sceneGraph.setEdgesVisibility(visible);
  }

  @Override
  public void facesVisibilityChanged(boolean visible)
  {
    m_sceneGraph.setFacesVisibility(visible);
  }

  @Override
  public void pointsVisibilityChanged(boolean visible)
  {
    m_sceneGraph.setPointsVisibility(visible);
  }

  @Override
  public void transparencyChanged(float value)
  {
    m_sceneGraph.setSkinTransparency(value);
  }

  @Override
  public void zScalingChanged(float factor)
  {
    m_sceneGraph.setZScale(factor);
  }

  @Override
  public void filteringActivated(boolean active)
  {
    m_sceneGraph.setFilteringState(active);
  }

  @Override
  public void filteringChanged(int imin, int imax, int jmin, int jmax, int kmin, int kmax)
  {
    m_sceneGraph.setFilter(imin, imax, jmin, jmax, kmin, kmax);
  }

  @Override
  public void dataRangeChanged(float min, float max)
  {
    m_sceneGraph.setDataRange(min, max);
  }

  @Override
  public void reverseChanged(boolean active)
  {
    m_sceneGraph.setReverseFiltering(active);
  }

  public void addDownsamplingListener(DownsamplingParamListener listener)
  {
    m_listeners.add(listener);
  }

  @Override
  public void propertyChanged(PillarMesh<PillarGrid> newMesh)
  {
    BoundedProperty sset = newMesh.getDataSet();
    m_sceneGraph.m_fullResSceneGraph.m_moScalarSetIjk.setScalarSet(sset);
    m_sceneGraph.m_lowResMesh.updateDataSet(sset);
    m_sceneGraph.m_lowResSceneGraph.m_moScalarSetIjk.setScalarSet(m_sceneGraph.m_lowResMesh.getDataSet());
    m_sceneGraph.adjustLowResolution(m_sceneGraph.m_lowResMesh.getRatio());
    m_sceneGraph.updateDataBoundaries(sset);
  }

  @Override
  public void hullVisibilityChanged(boolean visible)
  {
    m_sceneGraph.setHullVisibility(visible);
  }

  @Override
  public void hullTransparencyChanged(float value)
  {
    m_sceneGraph.setHullTransparency(value);
  }

  @Override
  public void hullOutlineVisibilityChanged(boolean visible)
  {
    m_sceneGraph.setOutlineVisibility(visible);
  }

  @Override
  public void setTransparencyType(SoGLRenderAction.TransparencyTypes transparencyType)
  {
    m_renderArea.getRenderArea().setTransparencyType(transparencyType);
  }

  @Override
  public void setColormap(PredefColorMapping colormap)
  {
    m_sceneGraph.setColormap(colormap);
  }

  @Override
  public void setAntiAliasing(float value)
  {
    m_renderArea.getRenderArea().setAntialiasingQuality(value);
    m_renderArea.getRenderArea().setAntialiasingMode(AntialiasingModes.FSAA);
  }

  @Override
  public void setFading(float value)
  {
    m_sceneGraph.setFading(value);
  }

}
