package meshvizxlm.eclipsemeshviz.gui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;
import com.openinventor.meshvizxlm.mesh.Dimension;

@SuppressWarnings("serial")
public class SlabAxisPanel extends SliderPanelContainer<SlabAxisPanel.SlabListener>
{

  private JCheckBox m_visibleCheckBox;
  private SliderPanel m_slabPosSliderPanel;
  private SliderPanel m_slabWidthSliderPanel;
  private SliderPanel m_slabGapSliderPanel;

  private Dimension m_axis;
  private ArrayList<SlabListener> m_listeners;

  /**
   * Create the panel.
   */
  public SlabAxisPanel(Dimension axis)
  {
    m_axis = axis;
    m_listeners = new ArrayList<SlabListener>();

    buildUI();
    addListeners();

    m_visibleCheckBox.setSelected(true);
    m_slabPosSliderPanel.setEnabled(true);
    m_slabWidthSliderPanel.setEnabled(true);
    m_slabGapSliderPanel.setEnabled(true);
  }

  public void addSlabListener(SlabListener listener)
  {
    m_listeners.add(listener);
  }

  public void updateSlabMax(int l)
  {
    m_slabPosSliderPanel.setSliderMax(l);
    m_slabWidthSliderPanel.setSliderMax(l + 1);
    m_slabGapSliderPanel.setSliderMax(l + 1);
  }

  public void setSlabOriginalValues(int l)
  {
    m_slabGapSliderPanel.setSliderValue(l + 1);
    m_slabPosSliderPanel.setSliderValue(l / 2);
    m_slabPosSliderPanel.setBoxSelected(true);
  }

  @Override
  public String toString()
  {
    switch ( m_axis )
    {
    case I :
      return "I axis";
    case J :
      return "J axis";
    case K :
      return "K axis";
    default:
      return m_axis.name();
    }
  }

  private void buildUI()
  {
    m_visibleCheckBox = new JCheckBox("Visible");

    JPanel buttonPanel = new JPanel();
    FlowLayout flowLayout = (FlowLayout) buttonPanel.getLayout();
    flowLayout.setAlignment(FlowLayout.LEFT);
    buttonPanel.add(m_visibleCheckBox);

    m_slabPosSliderPanel = new SliderPanel(0, 0, 0);
    flowLayout = (FlowLayout) m_slabPosSliderPanel.getLayout();
    flowLayout.setAlignment(FlowLayout.LEFT);

    m_slabWidthSliderPanel = new SliderPanel(0, 1, 1);
    flowLayout = (FlowLayout) m_slabWidthSliderPanel.getLayout();
    flowLayout.setAlignment(FlowLayout.LEFT);

    m_slabGapSliderPanel = new SliderPanel(1, 1, 1);
    flowLayout = (FlowLayout) m_slabGapSliderPanel.getLayout();
    flowLayout.setAlignment(FlowLayout.LEFT);

    m_slabPosSliderPanel.addInfoText("    Index");
    m_slabWidthSliderPanel.addInfoText("Thickness");
    m_slabWidthSliderPanel.setBoxSelected(true);
    m_slabGapSliderPanel.addInfoText("Gap ");

    JPanel fullPanel = new JPanel();
    fullPanel.setLayout(new BoxLayout(fullPanel, BoxLayout.Y_AXIS));
    fullPanel.add(buttonPanel);
    fullPanel.add(m_slabPosSliderPanel);
    fullPanel.add(m_slabWidthSliderPanel);
    fullPanel.add(m_slabGapSliderPanel);
    setLayout(new BorderLayout());
    add(fullPanel, BorderLayout.NORTH);
  }

  private void addListeners()
  {
    m_visibleCheckBox.addItemListener(new ItemListener()
    {
      @Override
      public void itemStateChanged(ItemEvent e)
      {
        boolean selected = e.getStateChange() == ItemEvent.SELECTED;

        for ( SlabListener listener : m_listeners )
          listener.slabVisibilityChanged(m_axis, selected);

        m_slabPosSliderPanel.setEnabled(selected);
        m_slabWidthSliderPanel.setEnabled(selected);
        m_slabGapSliderPanel.setEnabled(selected);
      }
    });

    m_slabPosSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        for ( SlabListener listener : m_listeners )
        {
          if ( !m_sliderDragStart )
            listener.startDownsampling();
          listener.slabPositionChanged(m_axis, (int) value);
        }
      }
    });

    m_slabWidthSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        for ( SlabListener listener : m_listeners )
        {
          if ( !m_sliderDragStart )
            listener.startDownsampling();
          listener.slabWidthChanged(m_axis, (int) value);
        }
      }
    });

    m_slabGapSliderPanel.addSliderPanelListener(new SliderPanel.Listener()
    {
      @Override
      public void stateChanged(float value)
      {
        for ( SlabListener listener : m_listeners )
        {
          if ( !m_sliderDragStart )
            listener.startDownsampling();
          listener.slabGapChanged(m_axis, (int) value);
        }
      }
    });

    addDownsamplingBehaviours(m_slabPosSliderPanel);
    addDownsamplingBehaviours(m_slabWidthSliderPanel);
  }

  @Override
  protected ArrayList<SlabListener> getDownsamplingListeners()
  {
    return m_listeners;
  }

  public interface SlabListener extends DownsamplingListener
  {
    public void slabVisibilityChanged(Dimension axis, boolean visible);

    public void slabPositionChanged(Dimension axis, int position);

    public void slabWidthChanged(Dimension axis, int width);

    public void slabGapChanged(Dimension axis, int gap);
  }
}
