package meshvizxlm.eclipsemeshviz.pillargrid;

interface CrackFunctor
{
  public float apply(int i, int j);
}

class StepICrackFctor implements CrackFunctor
{
  private int m_cst;
  private float m_offset;

  public StepICrackFctor(int cst, float offset)
  {
    m_cst = cst;
    m_offset = offset;
  }

  @Override
  public float apply(int i, int j)
  {
    return i < m_cst ? m_offset : 0;
  }
}

class StepJCrackFctor implements CrackFunctor
{
  private int m_cst;
  private float m_offset;

  public StepJCrackFctor(int cst, float offset)
  {
    m_cst = cst;
    m_offset = offset;
  }

  @Override
  public float apply(int i, int j)
  {
    return j < m_cst ? m_offset : 0;
  }
}

class LinearCrackFctor implements CrackFunctor
{
  private float m_a;
  private float m_b;
  private float m_offset;

  public LinearCrackFctor(float a, float b, float offset)
  {
    m_a = a;
    m_b = b;
    m_offset = offset;
  }

  @Override
  public float apply(int i, int j)
  {
    return m_a * i + m_b < j ? m_offset : 0;
  }
}
