package meshvizxlm.eclipsemeshviz.pillargrid;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import meshvizxlm.eclipsemeshviz.DemoSettings;

public class PillarGridZIPReader extends PillarGridFileIO
{

  // public void write(PillarGrid pillarGrid, File file) throws IOException
  // {
  // long startTime = System.currentTimeMillis();
  // ZipOutputStream zOut = new ZipOutputStream(new FileOutputStream(file));
  // {
  // ZipEntry zEntry = new ZipEntry("grid");
  // zOut.putNextEntry(zEntry);
  //
  // ByteBuffer byteBuffer = ByteBuffer.allocate(8 * 7);
  //
  // // writes grid dimensions
  // byteBuffer.putLong(pillarGrid.getDimI());
  // byteBuffer.putLong(pillarGrid.getDimJ());
  // byteBuffer.putLong(pillarGrid.getDimK());
  // byteBuffer.putLong(pillarGrid.m_numHFacesAtKLevel);
  //
  // byteBuffer.putLong(4);
  // byteBuffer.putLong(1);
  // // writes num zcorn
  // byteBuffer.putLong(pillarGrid.m_numZcorns);
  //
  // zOut.write(byteBuffer.array());
  //
  // // writes data
  // int i;
  // for ( int j = 0; j < 4; j++ )
  // {
  // byteBuffer.clear();
  // byteBuffer = ByteBuffer.allocate((int) (pillarGrid.m_numZcorns * 4));
  // for ( i = 0; i < pillarGrid.m_numZcorns / 4; i++ )
  // {
  // byteBuffer.putFloat(pillarGrid.m_zcorn[(int) (i + j *
  // pillarGrid.m_numZcorns / 4)]);
  // }
  // }
  // zOut.write(byteBuffer.array());
  // byteBuffer.clear();
  //
  // byteBuffer = ByteBuffer.allocate(pillarGrid.m_coord.length * 4);
  // for ( i = 0; i < pillarGrid.m_coord.length; i++ )
  // byteBuffer.putFloat(pillarGrid.m_coord[i]);
  // zOut.write(byteBuffer.array());
  // byteBuffer.clear();
  //
  // byteBuffer = ByteBuffer.allocate(8);
  // byteBuffer.putLong(pillarGrid.m_numNonActiveCells);
  // zOut.write(byteBuffer.array());
  // byteBuffer.clear();
  //
  // byteBuffer = ByteBuffer.allocate((int) pillarGrid.m_numNonActiveCells * 8);
  // if ( pillarGrid.hasNonActiveCells() )
  // for ( i = 0; i < pillarGrid.m_dimI * pillarGrid.m_dimJ * pillarGrid.m_dimK;
  // i++ )
  // {
  // byte[] actCell = new byte[] { (byte) (pillarGrid.m_actnum[i] ? 1 : 0) };
  // byteBuffer.put(actCell);
  // }
  // zOut.write(byteBuffer.array());
  // byteBuffer.clear();
  //
  // byteBuffer = ByteBuffer.allocate(8);
  // boolean flag = pillarGrid.isPorosityAvailable();
  // byte[] porosityExists = new byte[] { (byte) (flag ? 1 : 0) };
  // byteBuffer.put(porosityExists);
  // zOut.write(byteBuffer.array());
  // byteBuffer.clear();
  //
  // if ( flag )
  // {
  // byteBuffer = ByteBuffer.allocate(pillarGrid.m_dimI * pillarGrid.m_dimJ *
  // pillarGrid.m_dimK * 4);
  // for ( i = 0; i < pillarGrid.m_poro.length; i++ )
  // byteBuffer.putFloat(pillarGrid.m_poro[i]);
  // zOut.write(byteBuffer.array());
  // }
  // byteBuffer.clear();
  // DemoSettings.displayTime("pillar grid saved", System.currentTimeMillis() -
  // startTime);
  //
  // zOut.closeEntry();
  // }
  // zOut.close();
  // }

  @Override
  public void read(PillarGrid pillarGrid, File file) throws Exception
  {
    System.out.println("reading pillar grid from " + file.getName());
    try
    {
      long startTime = System.currentTimeMillis();
      ZipInputStream zIn = new ZipInputStream(new FileInputStream(file));
      ZipEntry entry = zIn.getNextEntry();
      boolean alreadyReadAFile = false;
      while ( alreadyReadAFile == false && entry != null )
      {
        if ( entry.getName().endsWith(".bin") )
        {
          alreadyReadAFile = true;
          BufferedInputStream in = new BufferedInputStream(zIn);

          // Read the dimension of the mesh
          ByteBuffer dimensionByteBuffer = ByteBuffer.allocate(Long.SIZE / 8 * 7);
          byte[] dimensionByteArray = dimensionByteBuffer.array();
          in.read(dimensionByteArray, 0, Long.SIZE / 8 * 7);
          dimensionByteBuffer.order(ByteOrder.LITTLE_ENDIAN);

          long dimI = dimensionByteBuffer.getLong();
          long dimJ = dimensionByteBuffer.getLong();
          long dimK = dimensionByteBuffer.getLong();
          pillarGrid.m_numHFacesAtKLevel = (int) dimensionByteBuffer.getLong();
          pillarGrid.setDim((int) dimI, (int) dimJ, (int) dimK);

          long CoorTSize = dimensionByteBuffer.getLong();
          long ActiveTSize = dimensionByteBuffer.getLong();

          long storedNumZCorns = dimensionByteBuffer.getLong();

          // Read the numZCorn
          // The reading is divided into 4 parts
          if ( pillarGrid.m_numZcorns == storedNumZCorns
              && (!DemoSettings.HORIZONTAL_FAULTS || pillarGrid.m_numHFacesAtKLevel == 2) )
          {
            int i;
            int iterationNumber = 0;
            int remainderZCorns = (int) pillarGrid.m_numZcorns;
            if ( pillarGrid.m_numZcorns - Integer.MAX_VALUE / 4 > 0 )
            {
              System.out.print(pillarGrid.m_numZcorns * Float.SIZE);
              iterationNumber = (int) (pillarGrid.m_numZcorns / (4 * Integer.MAX_VALUE / 4 / (Float.SIZE / 8)));
              remainderZCorns =
                  (int) pillarGrid.m_numZcorns - iterationNumber * (4 * Integer.MAX_VALUE / (Float.SIZE / 8) / 4);

            }
            for ( int j = 0; j < iterationNumber; j++ )
            {
              ByteBuffer zcornByteBuffer = ByteBuffer.allocate(4 * (Integer.MAX_VALUE / 4));
              byte[] zcornByteArray = zcornByteBuffer.array();
              in.read(zcornByteArray);
              zcornByteBuffer.order(ByteOrder.LITTLE_ENDIAN);

              for ( i = 0; i < (4 * (Integer.MAX_VALUE / 4) / (Float.SIZE / 8)); i++ )
              {
                pillarGrid.m_zcorn[i + j * (4 * (Integer.MAX_VALUE / 4)) / ((Float.SIZE / 8))] =
                    zcornByteBuffer.getFloat();
              }
            }
            ByteBuffer remainderZcornByteBuffer = ByteBuffer.allocate(remainderZCorns * (Float.SIZE / 8));

            byte[] remainderZcornByteArray = remainderZcornByteBuffer.array();
            in.read(remainderZcornByteArray);
            remainderZcornByteBuffer.order(ByteOrder.LITTLE_ENDIAN);

            for ( i = 0; i < remainderZCorns; i++ )
            {
              pillarGrid.m_zcorn[i + iterationNumber * (4 * (Integer.MAX_VALUE / 4)) / (Float.SIZE / 8)] =
                  remainderZcornByteBuffer.getFloat();
            }

            // Read the coordinates
            ByteBuffer coordByteBuffer = ByteBuffer.allocate(pillarGrid.m_coord.length * (Float.SIZE / 8));
            byte[] coordByteArray = coordByteBuffer.array();
            in.read(coordByteArray, 0, pillarGrid.m_coord.length * (Float.SIZE / 8));
            coordByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for ( i = 0; i < pillarGrid.m_coord.length; i++ )
            {
              pillarGrid.m_coord[i] = coordByteBuffer.getFloat();
            }

            // Read the number of active cells
            ByteBuffer longActNumByteBuffer = ByteBuffer.allocate(Long.SIZE / 8);
            byte[] longActNumByteArray = longActNumByteBuffer.array();
            in.read(longActNumByteArray, 0, Long.SIZE / 8);
            longActNumByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            pillarGrid.m_numNonActiveCells = longActNumByteBuffer.getLong();

            // Read the value of the active cells
            if ( pillarGrid.m_numNonActiveCells > 0 )
            {
              ByteBuffer actNumByteBuffer =
                  ByteBuffer.allocate(pillarGrid.m_dimI * pillarGrid.m_dimJ * pillarGrid.m_dimK * (Byte.SIZE / 8));
              byte[] actNumByteArray = actNumByteBuffer.array();
              in.read(actNumByteArray, 0, pillarGrid.m_dimI * pillarGrid.m_dimJ * pillarGrid.m_dimK * (Byte.SIZE / 8));
              actNumByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
              byte actCell;
              for ( i = 0; i < pillarGrid.m_dimI * pillarGrid.m_dimJ * pillarGrid.m_dimK; i++ )
              {
                actCell = actNumByteBuffer.get();
                pillarGrid.m_actnum[i] = actCell != 0;
              }

              // Read the flag of the porosity
              ByteBuffer flagPorosityByteBuffer = ByteBuffer.allocate(Byte.SIZE / 8);
              byte[] flagPorosityByteArray = flagPorosityByteBuffer.array();
              in.read(flagPorosityByteArray, 0, Byte.SIZE / 8);
              flagPorosityByteBuffer.order(ByteOrder.LITTLE_ENDIAN);

              boolean flag = flagPorosityByteBuffer.array()[0] != 0;
              pillarGrid.setAvailablePorosity(flag);

              // Read the porosity
              if ( flag == true )
              {
                ByteBuffer porosityByteBuffer =
                    ByteBuffer.allocate(pillarGrid.m_dimI * pillarGrid.m_dimJ * pillarGrid.m_dimK * (Float.SIZE / 8));
                byte[] porosityByteArray = porosityByteBuffer.array();
                in.read(porosityByteArray, 0, pillarGrid.m_dimI * pillarGrid.m_dimJ * pillarGrid.m_dimK
                    * (Float.SIZE / 8));
                porosityByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                for ( i = 0; i < pillarGrid.m_dimI * pillarGrid.m_dimJ * pillarGrid.m_dimK; i++ )
                {
                  pillarGrid.m_poro[i] = porosityByteBuffer.getFloat();
                }
              }
            }

          }
          else
            throw new Exception("wrong file format " + file.getName());
        }

        DemoSettings.displayTime("pillar grid read", System.currentTimeMillis() - startTime);
        entry = zIn.getNextEntry();
      }
      zIn.closeEntry();
      zIn.close();
    }

    catch (Exception ex)
    {
      throw ex;
    }
    finally
    {}
  }
}
