package meshvizxlm.eclipsemeshviz.wrappers;

import meshvizxlm.eclipsemeshviz.pillargrid.PillarGrid;
import meshvizxlm.eclipsemeshviz.wrappers.geometry.AbstractCachedPillarGeometry;
import meshvizxlm.eclipsemeshviz.wrappers.geometry.IndexedPillarGeometry;
import meshvizxlm.eclipsemeshviz.wrappers.topology.CachedPillarTopology;

public class CachedTopoPillarMesh<T extends PillarGrid> extends PillarMesh<T>
{

  public CachedTopoPillarMesh(T grid)
  {
    super(grid, new IndexedPillarGeometry(grid), "CachedTopoPillarMesh");
    generateMesh(grid);
  }

  public CachedTopoPillarMesh(T grid, AbstractCachedPillarGeometry geometry, String name)
  {
    super(grid, geometry, name);
    generateMesh(grid);
  }

  private void generateMesh(T grid)
  {
    long t1 = System.currentTimeMillis();
    m_topology = new CachedPillarTopology<T>(grid, (AbstractCachedPillarGeometry) m_geometry);
    long t2 = System.currentTimeMillis();

    displayCreationTime(t2 - t1);
    displayInfo();
  }
}
